/*
 * Decompiled with CFR 0.152.
 */
package aurora.application.script.engine;

import aurora.application.script.engine.RhinoScriptEngine;
import aurora.application.script.scriptobject.CookieObject;
import aurora.application.script.scriptobject.ModelServiceObject;
import aurora.application.script.scriptobject.ScriptUtil;
import aurora.application.script.scriptobject.SessionObject;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import javax.script.ScriptContext;
import javax.script.ScriptException;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import uncertain.composite.CompositeMap;

public class AuroraScriptEngine
extends RhinoScriptEngine {
    public static final String aurora_core_js = "aurora-core.js";
    public static final String KEY_SERVICE_CONTEXT = "service_context";
    public static final String KEY_SSO = "sso";
    private static String js = ScriptUtil.loadAuroraCore();
    private CompositeMap service_context;

    public AuroraScriptEngine(CompositeMap context) {
        if (context == null) {
            throw new NullPointerException("init context for 'AuroraScriptEngine' can not be null.");
        }
        this.service_context = context;
    }

    private void preDefine(Context cx, Scriptable scope) {
        try {
            ScriptableObject so;
            cx.putThreadLocal((Object)KEY_SERVICE_CONTEXT, (Object)this.service_context);
            ScriptableObject.defineClass((Scriptable)scope, aurora.application.script.scriptobject.CompositeMap.class);
            ScriptableObject.defineClass((Scriptable)scope, SessionObject.class);
            ScriptableObject.defineClass((Scriptable)scope, CookieObject.class);
            ScriptableObject.defineClass((Scriptable)scope, ModelServiceObject.class);
            Scriptable ctx = cx.newObject(scope, "CompositeMap", new Object[]{this.service_context});
            ScriptableObject.defineProperty((Scriptable)scope, (String)"$ctx", (Object)ctx, (int)0);
            Scriptable ses = cx.newObject(scope, "Session");
            ScriptableObject.defineProperty((Scriptable)scope, (String)"$session", (Object)ses, (int)0);
            Scriptable cok = cx.newObject(scope, "Cookie");
            ScriptableObject.defineProperty((Scriptable)scope, (String)"$cookie", (Object)cok, (int)0);
            cx.evaluateString(scope, js, aurora_core_js, 1, null);
            if (ctx instanceof ScriptableObject) {
                so = (ScriptableObject)ctx;
                so.sealObject();
            }
            if (ses instanceof ScriptableObject) {
                so = (ScriptableObject)ses;
                so.sealObject();
            }
            if (cok instanceof ScriptableObject) {
                so = (ScriptableObject)cok;
                so.sealObject();
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    @Override
    public Object eval(Reader reader, ScriptContext ctxt) throws ScriptException {
        Object ret;
        Context cx = AuroraScriptEngine.enterContext();
        try {
            Scriptable scope = this.getRuntimeScope(ctxt);
            this.preDefine(cx, scope);
            String filename = (String)this.get("javax.script.filename");
            filename = filename == null ? "<Unknown source>" : filename;
            ret = cx.evaluateReader(scope, reader, filename, 1, null);
        }
        catch (RhinoException re) {
            int line = re.lineNumber();
            line = line == 0 ? -1 : line;
            String msg = re instanceof JavaScriptException ? String.valueOf(((JavaScriptException)re).getValue()) : re.toString();
            msg = this.formatExceptionMessage(msg);
            ScriptException se = new ScriptException(msg, re.sourceName(), line);
            se.initCause(re);
            throw se;
        }
        catch (IOException ee) {
            throw new ScriptException(ee);
        }
        finally {
            Context.exit();
        }
        return this.unwrapReturnValue(ret);
    }

    private String formatExceptionMessage(String msg) {
        int idx = msg.indexOf(58);
        if (idx == -1) {
            return msg;
        }
        String s = msg.substring(0, idx);
        if (s.indexOf("mozilla") != -1) {
            return msg.substring(idx + 1);
        }
        return msg;
    }
}

