/*
 * Decompiled with CFR 0.152.
 */
package aurora.application.script.engine;

import aurora.application.script.engine.AuroraScriptEngine;
import aurora.application.script.scriptobject.ScriptShareObject;
import javax.script.ScriptException;
import uncertain.composite.CompositeMap;
import uncertain.composite.TextParser;
import uncertain.ocm.IObjectRegistry;

public class ScriptRunner {
    private String exp;
    private AuroraScriptEngine engine;
    private CompositeMap context = null;
    private ScriptShareObject sso;

    public ScriptRunner(String script) {
        this.exp = script;
    }

    public ScriptRunner(String script, CompositeMap context) {
        this(script);
        this.context = context;
        this.sso = (ScriptShareObject)((Object)context.get("sso"));
        if (this.sso == null) {
            this.sso = new ScriptShareObject();
            context.put("sso", (Object)this.sso);
        }
    }

    public ScriptRunner(String script, CompositeMap context, IObjectRegistry registry) {
        this(script, context);
        this.sso.put(registry);
    }

    public String getOriginalScript() {
        return this.exp;
    }

    public String getParsedScript() {
        if (this.context == null) {
            return this.exp;
        }
        return TextParser.parse(this.exp, this.context);
    }

    public Object run() throws ScriptException {
        this.engine = this.sso.getEngine();
        if (this.engine == null) {
            this.engine = new AuroraScriptEngine(this.context);
            this.sso.put(this.engine);
        }
        String str = this.getParsedScript();
        return this.engine.eval(str);
    }
}

