/*
 * Decompiled with CFR 0.152.
 */
package aurora.application.script.scriptobject;

import aurora.application.script.engine.AuroraScriptEngine;
import aurora.application.script.scriptobject.ScriptShareObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import uncertain.composite.CompositeMap;
import uncertain.ocm.IObjectRegistry;

public class ScriptUtil {
    public static Scriptable newObject(Scriptable scope, String clsName) {
        Context ctx = Context.getCurrentContext();
        Scriptable topScope = ScriptableObject.getTopLevelScope((Scriptable)scope);
        return ctx.newObject(topScope, clsName);
    }

    public static NativeArray newArray(Scriptable scope, int length) {
        Context ctx = Context.getCurrentContext();
        Scriptable topScope = ScriptableObject.getTopLevelScope((Scriptable)scope);
        return (NativeArray)ctx.newArray(topScope, length);
    }

    public static AuroraScriptEngine getEngine(CompositeMap context) {
        ScriptShareObject sso = (ScriptShareObject)((Object)context.get("sso"));
        if (sso == null) {
            return null;
        }
        return sso.getEngine();
    }

    public static IObjectRegistry getObjectRegistry(CompositeMap context) {
        ScriptShareObject sso = (ScriptShareObject)((Object)context.get("sso"));
        if (sso == null) {
            return null;
        }
        return sso.getObjectRegistry();
    }

    public static CompositeMap getContext() {
        return (CompositeMap)Context.getCurrentContext().getThreadLocal((Object)"service_context");
    }

    public static boolean isValid(Object obj) {
        return obj != null && obj != Context.getUndefinedValue();
    }

    public static final synchronized String loadAuroraCore() {
        try {
            InputStream is = AuroraScriptEngine.class.getResourceAsStream("aurora-core.js");
            if (is != null) {
                BufferedReader br = new BufferedReader(new InputStreamReader(is));
                StringBuilder sb = new StringBuilder(1024);
                String line = null;
                while ((line = br.readLine()) != null) {
                    sb.append(line);
                    sb.append('\n');
                }
                is.close();
                br.close();
                return sb.toString();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return "";
    }
}

