/*
 * Decompiled with CFR 0.152.
 */
package aurora.database.features;

import aurora.bm.BusinessModel;
import aurora.bm.Field;
import aurora.bm.IModelFactory;
import aurora.bm.Operation;
import aurora.database.DBUtil;
import aurora.database.FetchDescriptor;
import aurora.database.ParsedSql;
import aurora.database.ResultSetLoader;
import aurora.database.SqlRunner;
import aurora.database.features.MultiLanguageDisplay;
import aurora.database.profile.IDatabaseFactory;
import aurora.database.rsconsumer.CompositeMapCreator;
import aurora.database.service.BusinessModelService;
import aurora.database.service.BusinessModelServiceContext;
import java.io.IOException;
import java.sql.ResultSet;
import java.util.List;
import java.util.Set;
import uncertain.composite.CompositeMap;
import uncertain.logging.LoggingContext;

public class MultiLanguageStorage
extends MultiLanguageDisplay {
    public MultiLanguageStorage(IModelFactory modelFactory, IDatabaseFactory databaseFactory) throws IOException {
        super(modelFactory, databaseFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preCreateInsertStatement(BusinessModel model, BusinessModelServiceContext context) throws Exception {
        if (!this.hasMlFields) {
            return;
        }
        if (this.mLogger == null) {
            this.mLogger = LoggingContext.getLogger(context.getObjectContext(), "aurora.database");
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select ");
        Field[] fields = model.getFields();
        int count = 0;
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            if (!field.getMultiLanguage()) continue;
            if (count != 0) {
                sql.append(",");
            }
            sql.append(this.sequence + " as " + field.getName());
            ++count;
        }
        sql.append(" from dual");
        ParsedSql s = new ParsedSql(sql.toString());
        SqlRunner runner = new SqlRunner(context, s);
        runner.setConnectionName(context.getBusinessModel().getDataSourceName());
        ResultSet rs = null;
        try {
            rs = runner.query(new CompositeMap());
            ResultSetLoader loader = new ResultSetLoader();
            loader.setFieldNameCase((byte)2);
            FetchDescriptor desc = FetchDescriptor.fetchAll();
            CompositeMapCreator consumer = new CompositeMapCreator();
            loader.loadByResultSet(rs, desc, consumer);
            CompositeMap result = consumer.getCompositeMap();
            CompositeMap currParamMap = context.getCurrentParameter();
            List list = result.getChilds();
            CompositeMap child = (CompositeMap)list.get(0);
            Set kSet = child.keySet();
            for (String key : kSet) {
                currParamMap.put(key, child.get(key));
            }
            context.setCurrentParameter(currParamMap);
        }
        finally {
            DBUtil.printTraceInfo("MultiLanguageStorage Insert", this.mLogger, runner);
            DBUtil.closeResultSet(rs);
        }
    }

    public void postExecuteDmlStatement(BusinessModelServiceContext context) throws Exception {
        if (!this.hasMlFields) {
            return;
        }
        BusinessModel model = context.getBusinessModel();
        String operation = context.getOperation();
        Field[] fields = model.getFields();
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            if (field.isReferenceField() || !field.getMultiLanguage()) continue;
            if ("insert".equalsIgnoreCase(operation.toLowerCase()) && field.isForInsert() && model.getOperation("insert") == null) {
                this.createMultiLanguageSql(context, field, "update");
                continue;
            }
            if ("update".equalsIgnoreCase(operation.toLowerCase()) && field.isForUpdate() && model.getOperation("update") == null) {
                this.createMultiLanguageSql(context, field, "update");
                continue;
            }
            this.createMultiLanguageSql(context, field, "delete");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void createMultiLanguageSql(BusinessModelServiceContext context, Field mlFiled, String operation) throws Exception {
        if (this.mLogger == null) {
            this.mLogger = LoggingContext.getLogger(context.getObjectContext(), "aurora.database");
        }
        CompositeMap currentParameter = context.getCurrentParameter();
        BusinessModel bm = context.getBusinessModel();
        currentParameter.putString(this.refTable, bm.getBaseTable().toUpperCase());
        currentParameter.putString(this.refField, mlFiled.getName().toUpperCase());
        currentParameter.putString(this.mlDescription, currentParameter.getString(mlFiled.getMultiLanguageDescField()));
        currentParameter.putString(this.pkId, currentParameter.getString(mlFiled.getName()));
        Operation op = this.mlModel.getOperation(operation);
        String sql = op.getSql();
        ParsedSql s = new ParsedSql();
        s.parse(sql);
        SqlRunner runner = BusinessModelService.createSqlRunner(context, s);
        try {
            runner.update(context.getCurrentParameter());
        }
        finally {
            DBUtil.printTraceInfo("MultiLanguageStorage " + operation, this.mLogger, runner);
        }
    }
}

