/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.api.statistics.cvs;

import aurora.ide.api.statistics.cvs.CVSEntryLineTag;
import aurora.ide.api.statistics.cvs.CVSTag;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class FolderSyncInfo {
    protected static final String SEPARATOR = "/";
    public static final String SERVER_SEPARATOR = "/";
    public static final String CURRENT_LOCAL_FOLDER = ".";
    public static final char COLON = ':';
    public static final char SEMICOLON = ';';
    public static final char HOST_SEPARATOR = '@';
    public static final char PORT_SEPARATOR = '#';
    public static final String VIRTUAL_DIRECTORY = "CVSROOT/Emptydir";
    protected String repository;
    protected String root;
    private CVSEntryLineTag tag;
    protected boolean isStatic;

    public FolderSyncInfo(String repo, String root, CVSTag tag, boolean isStatic) {
        this.repository = repo;
        this.root = root.intern();
        this.ensureRepositoryRelativeToRoot();
        this.isStatic = isStatic;
        this.setTag(tag);
    }

    private void ensureRepositoryRelativeToRoot() {
        String rootDir = this.getRootDirectory();
        if (this.repository.startsWith(rootDir)) {
            this.repository = this.repository.substring(rootDir.length());
        }
        if (this.repository.startsWith("/")) {
            this.repository = this.repository.substring("/".length());
        }
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof FolderSyncInfo)) {
            return false;
        }
        FolderSyncInfo syncInfo = (FolderSyncInfo)other;
        if (!this.getRoot().equals(syncInfo.getRoot())) {
            return false;
        }
        if (!this.getRepository().equals(syncInfo.getRepository())) {
            return false;
        }
        if (this.getIsStatic() != syncInfo.getIsStatic()) {
            return false;
        }
        if (this.getTag() == null || syncInfo.getTag() == null) {
            if (this.getTag() == null && syncInfo.getTag() != null && syncInfo.getTag().getType() != 0) {
                return false;
            }
            if (syncInfo.getTag() == null && this.getTag() != null && this.getTag().getType() != 0) {
                return false;
            }
        } else if (!this.getTag().equals(syncInfo.getTag())) {
            return false;
        }
        return true;
    }

    public String getRoot() {
        return this.root;
    }

    public String getRootDirectory() {
        try {
            String root = this.getRoot();
            int index = root.indexOf(64);
            if (index == -1) {
                index = root.indexOf(58);
                if (index == 0) {
                    index = root.indexOf(58, index + 1);
                    index = root.indexOf(58, index + 1);
                }
                if (index == -1 && (index = root.indexOf("/")) != -1) {
                    --index;
                }
            } else {
                index = root.indexOf(58, index + 1);
            }
            char c = root.charAt(++index);
            while (Character.isDigit(c)) {
                c = root.charAt(++index);
            }
            return root.substring(index);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    public CVSEntryLineTag getTag() {
        return this.tag;
    }

    public String getRepository() {
        return this.repository;
    }

    public boolean getIsStatic() {
        return this.isStatic;
    }

    public String getRemoteLocation() {
        return FolderSyncInfo.appendPath(this.getRootDirectory(), this.getRepository());
    }

    public int hashCode() {
        return this.getRoot().hashCode() | this.getRepository().hashCode();
    }

    protected void setTag(CVSTag tag) {
        this.tag = tag == null || tag.equals(CVSTag.DEFAULT) ? null : new CVSEntryLineTag(tag);
    }

    public String toString() {
        return this.getRoot() + "/" + this.getRepository() + "/" + this.getTag();
    }

    public boolean isSameMapping(FolderSyncInfo other) {
        if (other == null) {
            return false;
        }
        return this.getRoot().equals(other.getRoot()) && this.getRepository().equals(other.getRepository());
    }

    public byte[] getBytes() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(out);
        try {
            dos.writeUTF(this.getRoot());
            dos.writeUTF(this.getRepository());
            CVSEntryLineTag t = this.getTag();
            if (t == null) {
                dos.writeUTF("");
            } else {
                dos.writeUTF(t.toString());
            }
            dos.writeBoolean(this.getIsStatic());
            dos.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return out.toByteArray();
    }

    public static FolderSyncInfo getFolderSyncInfo(byte[] bytes) {
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        DataInputStream dis = new DataInputStream(in);
        try {
            String root = dis.readUTF();
            String repository = dis.readUTF();
            String tagName = dis.readUTF();
            CVSEntryLineTag tag = tagName.length() == 0 ? null : new CVSEntryLineTag(tagName);
            boolean isStatic = dis.readBoolean();
            return new FolderSyncInfo(repository, root, tag, isStatic);
        }
        catch (IOException e) {
            return null;
        }
    }

    public boolean isVirtualDirectory() {
        return this.getRepository().equals(VIRTUAL_DIRECTORY);
    }

    public FolderSyncInfo asImmutable() {
        return this;
    }

    public static String appendPath(String prefix, String suffix) {
        if (prefix.length() == 0 || prefix.equals(CURRENT_LOCAL_FOLDER)) {
            return suffix;
        }
        if (prefix.endsWith("/")) {
            if (suffix.startsWith("/")) {
                return prefix + suffix.substring(1);
            }
            return prefix + suffix;
        }
        if (suffix.startsWith("/")) {
            return prefix + suffix;
        }
        return prefix + "/" + suffix;
    }
}

