/*
 * Decompiled with CFR 0.152.
 */
package aurora.presentation.component.std;

import aurora.presentation.BuildSession;
import aurora.presentation.ViewContext;
import aurora.presentation.component.std.Field;
import java.io.IOException;
import java.util.Map;
import uncertain.composite.CompositeMap;

public class InputField
extends Field {
    protected static final String CLASSNAME_EMPTYTEXT = "item-emptyText";

    @Override
    protected String getDefaultClass(BuildSession session, ViewContext context) {
        CompositeMap view = context.getView();
        Map map = context.getMap();
        String wrapClass = super.getDefaultClass(session, context);
        String emptyText = view.getString("emptytext", "");
        String value = (String)map.get("value");
        if (!"".equals(emptyText) && "".equals(value)) {
            wrapClass = wrapClass + " item-emptyText";
        }
        return wrapClass;
    }

    @Override
    public void onCreateViewContent(BuildSession session, ViewContext context) throws IOException {
        super.onCreateViewContent(session, context);
        CompositeMap view = context.getView();
        Map map = context.getMap();
        Integer width = (Integer)map.get("width");
        map.put("inputwidth", new Integer(width - 3));
        String value = (String)map.get("value");
        String emptyText = view.getString("emptytext", "");
        if (!"".equals(emptyText) && "".equals(value)) {
            map.put("value", emptyText);
            this.addConfig("emptytext", emptyText);
        }
        this.addConfig("editable", new Boolean(view.getBoolean("editable", true)));
        try {
            Integer tabindex = view.getInt("tabindex");
            if (tabindex != null) {
                map.put("tabindex", tabindex);
                this.addConfig("tabindex", tabindex);
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
    }
}

