/*
 * Decompiled with CFR 0.152.
 */
package aurora.presentation.component.std;

import aurora.presentation.BuildSession;
import aurora.presentation.ViewContext;
import aurora.presentation.component.std.IDGenerator;
import aurora.presentation.component.std.ToolBar;
import java.io.IOException;
import java.util.Map;
import org.xml.sax.SAXException;
import uncertain.composite.CompositeLoader;
import uncertain.composite.CompositeMap;

public class NavBar
extends ToolBar {
    public static final String PROPERTITY_DATASET = "dataset";
    public static final String PROPERTITY_NAVBAR_TYPE = "navbartype";
    public static final String PROPERTITY_PAGE_SIZE_EDITABLE = "enablepagesize";
    public static final String PROPERTITY_MAX_PAGE_COUNT = "maxpagecount";

    @Override
    protected int getDefaultWidth() {
        return -1;
    }

    @Override
    public void onCreateViewContent(BuildSession session, ViewContext context) throws IOException {
        try {
            CompositeMap view = context.getView();
            Map map = context.getMap();
            String dataset = view.getString(PROPERTITY_DATASET);
            map.put(PROPERTITY_DATASET, dataset);
            String id = view.getString("id", "");
            if ("".equals(id)) {
                id = IDGenerator.getInstance().generate();
            }
            view.putString("id", id);
            String type = view.getString(PROPERTITY_NAVBAR_TYPE, "complex");
            map.put(PROPERTITY_NAVBAR_TYPE, type);
            map.put(PROPERTITY_MAX_PAGE_COUNT, new Integer(view.getInt(PROPERTITY_MAX_PAGE_COUNT, 10)));
            if ("simple".equalsIgnoreCase(type) || "tiny".equalsIgnoreCase(type)) {
                view.put("classname", view.getString("classname") + " simple-navbar");
                this.createSimpleNavBar(session, context);
            } else {
                this.createComplexNavBar(session, context);
            }
        }
        catch (SAXException e) {
            throw new IOException(e.getMessage());
        }
        super.onCreateViewContent(session, context);
    }

    private void createSimpleNavBar(BuildSession session, ViewContext context) throws IOException, SAXException {
        CompositeMap view = context.getView();
        CompositeLoader loader = new CompositeLoader();
        String pageInfoText = "<div atype='displayInfo' class='nav-label' style='float:right;'></div>";
        CompositeMap pageInfo = loader.loadFromString(pageInfoText, "UTF-8");
        view.addChild(pageInfo);
    }

    private void createComplexNavBar(BuildSession session, ViewContext context) throws IOException, SAXException {
        Map map = context.getMap();
        CompositeMap view = context.getView();
        String dataset = view.getString(PROPERTITY_DATASET);
        view.addChild(this.createButton("nav-firstpage", "background-position:1px 1px;", "function(){$('" + dataset + "').firstPage()}", session.getLocalizedPrompt("HAP_FIRST_PAGE")));
        view.addChild(this.createButton("nav-prepage", "background-position:0px -31px;", "function(){$('" + dataset + "').prePage()}", session.getLocalizedPrompt("HAP_PREVIOUS_PAGE")));
        view.addChild(this.createSeparator());
        CompositeLoader loader = new CompositeLoader();
        String pagetext = "<div class='item-label' atype='currentPage' style='margin-left:2px;margin-right:2px;'>&#160;</div>";
        CompositeMap pageinfo = loader.loadFromString(pagetext, "UTF-8");
        view.addChild(pageinfo);
        String inputId = IDGenerator.getInstance().generate();
        map.put("inputid", inputId);
        CompositeMap button = new CompositeMap("numberField");
        button.setNameSpaceURI("http://www.aurora-framework.org/application");
        button.putString("id", inputId);
        button.put("iscust", new Boolean(false));
        button.put("width", new Integer(30));
        button.put("allowdecimals", new Boolean(false));
        button.put("allownegative", new Boolean(false));
        view.addChild(button);
        String text = "<div class='item-label' atype='pageInfo' style='margin-left:5px;margin-right:5px;'>    </div>";
        CompositeMap totalpage = loader.loadFromString(text, "UTF-8");
        view.addChild(totalpage);
        view.addChild(this.createSeparator());
        view.addChild(this.createButton("nav-nextpage", "background-position:1px -47px;", "function(){$('" + dataset + "').nextPage()}", session.getLocalizedPrompt("HAP_NEXT_PAGE")));
        view.addChild(this.createButton("nav-lastpage", "background-position:1px -15px", "function(){$('" + dataset + "').lastPage()}", session.getLocalizedPrompt("HAP_LAST_PAGE")));
        view.addChild(this.createButton("nav-refresh", "background-position:0px -64px;", "function(){$('" + dataset + "').query($('" + dataset + "').currentPage)}", session.getLocalizedPrompt("HAP_REFRESH")));
        view.addChild(this.createSeparator());
        if (view.getBoolean(PROPERTITY_PAGE_SIZE_EDITABLE, true)) {
            String pageSizeInfo = "<div class='item-label' atype='pageSizeInfo' style='margin-left:5px;margin-right:5px;'>    </div>";
            CompositeMap pagesize = loader.loadFromString(pageSizeInfo, "UTF-8");
            view.addChild(pagesize);
            String comboBoxId = IDGenerator.getInstance().generate();
            map.put("comboBoxId", comboBoxId);
            CompositeMap comboBox = new CompositeMap("comboBox");
            comboBox.put("iscust", new Boolean(false));
            comboBox.setNameSpaceURI("http://www.aurora-framework.org/application");
            comboBox.putString("id", comboBoxId);
            comboBox.put("width", new Integer(50));
            comboBox.put("fetchrecord", new Boolean(false));
            view.addChild(comboBox);
            String pageSizeInfo2 = "<div class='item-label' atype='pageSizeInfo2' style='margin-left:5px;margin-right:5px;'>    </div>";
            CompositeMap pagesize2 = loader.loadFromString(pageSizeInfo2, "UTF-8");
            view.addChild(pagesize2);
            view.addChild(this.createSeparator());
        }
        String pageInfoText = "<div atype='displayInfo' class='item-label' style='float:right;'></div>";
        CompositeMap pageInfo = loader.loadFromString(pageInfoText, "UTF-8");
        view.addChild(pageInfo);
    }

    private CompositeMap createSeparator() {
        CompositeMap sep = new CompositeMap("separator");
        sep.setNameSpaceURI("http://www.aurora-framework.org/application");
        return sep;
    }

    private CompositeMap createButton(String clz, String style, String function, String title) {
        CompositeMap button = new CompositeMap("button");
        button.setNameSpaceURI("http://www.aurora-framework.org/application");
        button.put("width", new Integer(16));
        button.put("icon", "null");
        button.put("iscust", new Boolean(false));
        button.put("btnclass", clz);
        button.put("title", title);
        button.put("btnstyle", style);
        if (!"".equals(function)) {
            button.put("click", function);
        }
        return button;
    }
}

