/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.excelreport;

import aurora.plugin.excelreport.CellStyleWrap;
import aurora.plugin.excelreport.ExcelReport;
import aurora.plugin.excelreport.SheetWrap;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import uncertain.composite.CompositeMap;

public class ExcelFactory {
    Map<String, CellStyle> styles;
    public final String KEY_CONTENT = "content";
    public final String KEY_FORMULA = "formula";
    private CreationHelper createHelper;

    public void createExcel(CompositeMap context, ExcelReport excelReport) throws Exception {
        if (excelReport.getSheets() == null) {
            return;
        }
        Object wb = null;
        wb = ".xlsx".equalsIgnoreCase(excelReport.getFormat()) ? new XSSFWorkbook() : new HSSFWorkbook();
        this.createHelper = wb.getCreationHelper();
        if (excelReport.getStyles() != null) {
            this.styles = this.createStyles((Workbook)wb, excelReport);
        }
        for (SheetWrap sheetObj : excelReport.getSheets()) {
            sheetObj.createSheet((Workbook)wb, context, this);
        }
        wb.write(excelReport.getOutputStream());
        excelReport.getOutputStream().close();
    }

    private Map<String, CellStyle> createStyles(Workbook wb, ExcelReport excelReport) {
        HashMap<String, CellStyle> styles = new HashMap<String, CellStyle>();
        for (CellStyleWrap cellStyleObj : excelReport.getStyles()) {
            CellStyle style = cellStyleObj.createStyle(wb);
            styles.put(cellStyleObj.getName(), style);
        }
        return styles;
    }

    public static Row createRow(Sheet sheet, int rownum) {
        Row row = sheet.getRow(rownum - 1);
        if (row == null) {
            row = sheet.createRow(rownum - 1);
        }
        return row;
    }

    public static boolean isNotNull(Object value) {
        return value != null && !"".equals(value);
    }

    public CellStyle getStyle(String styleName) {
        if (this.styles != null) {
            CellStyle style = this.styles.get(styleName);
            return style;
        }
        return null;
    }

    public CreationHelper getCreateHelper() {
        return this.createHelper;
    }

    public void setCellValue(Cell cell, Object value) {
        this.setCellValue(cell, value, null);
    }

    public void setCellValue(Cell cell, Object value, String dataType) {
        if (value == null) {
            return;
        }
        if (ExcelFactory.isNotNull(dataType)) {
            if ("String".equals(dataType)) {
                cell.setCellValue(this.getCreateHelper().createRichTextString(value.toString()));
            }
            if ("Number".equals(dataType)) {
                cell.setCellValue(Double.valueOf(value.toString()).doubleValue());
            } else {
                cell.setCellValue(this.getCreateHelper().createRichTextString(value.toString()));
            }
        } else {
            if (value instanceof String) {
                cell.setCellValue(this.getCreateHelper().createRichTextString((String)value));
                return;
            }
            if (value instanceof Number) {
                cell.setCellValue(Double.parseDouble(value.toString()));
                return;
            }
            if (value instanceof Date) {
                cell.setCellValue((Date)value);
                return;
            }
            cell.setCellValue(value.toString());
            return;
        }
    }
}

