/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.excelreport;

import aurora.plugin.excelreport.CellData;
import aurora.plugin.excelreport.DynamicContent;
import aurora.plugin.excelreport.ExcelFactory;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellReference;
import uncertain.composite.CompositeMap;
import uncertain.composite.TextParser;

public class SheetWrap {
    String name;
    DynamicContent dynamicContent;
    CellData[] staticContent;
    private int offsetRowIndex = 0;
    private Sheet excelSheet;
    ExcelFactory excelFactory;
    int totalCount = -1;

    public void createSheet(Workbook wb, CompositeMap context, ExcelFactory excelFactory) {
        this.excelSheet = wb.createSheet(this.getName());
        this.excelFactory = excelFactory;
        if (this.getDynamicContent() != null) {
            this.offsetRowIndex = this.getDynamicContent().createContent(context, excelFactory, this.excelSheet);
        }
        if (this.getStaticContent() != null) {
            this.createStaticContent(context);
        }
    }

    void createStaticContent(CompositeMap context) {
        if (this.getStaticContent() == null) {
            return;
        }
        for (CellData cellConfig : this.getStaticContent()) {
            int rowIndex = cellConfig.getOffset() ? this.offsetRowIndex + cellConfig.getRow() : cellConfig.getRow();
            Row row = ExcelFactory.createRow(this.excelSheet, rowIndex);
            int colIndex = CellReference.convertColStringToIndex((String)cellConfig.getCell());
            Cell cell = row.createCell(colIndex);
            CellStyle cellStyle = this.excelFactory.getStyle(cellConfig.getStyleName());
            if (ExcelFactory.isNotNull(cellStyle)) {
                cell.setCellStyle(cellStyle);
            }
            if (cellConfig.getRange() != null) {
                this.excelSheet.addMergedRegion(CellRangeAddress.valueOf((String)cellConfig.getRange()));
            }
            if ("formula".equals(cellConfig.getType())) {
                cell.setCellFormula(cellConfig.getValue());
                continue;
            }
            String value = cellConfig.getValue();
            this.excelFactory.setCellValue(cell, TextParser.parse((String)value, (CompositeMap)context), cellConfig.getDataType());
        }
    }

    public DynamicContent getDynamicContent() {
        return this.dynamicContent;
    }

    public void addDynamicContent(DynamicContent dynamicContent) {
        this.dynamicContent = dynamicContent;
    }

    public CellData[] getStaticContent() {
        return this.staticContent;
    }

    public void setStaticContent(CellData[] staticContent) {
        this.staticContent = staticContent;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

