/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.memcached;

import aurora.plugin.memcached.MemcachedClientWrapper;
import aurora.plugin.memcached.XmemcachedClientWrapper;
import java.io.IOException;
import net.rubyeye.xmemcached.MemcachedClient;
import net.rubyeye.xmemcached.XMemcachedClientBuilder;
import net.rubyeye.xmemcached.utils.AddrUtil;
import uncertain.cache.ICache;
import uncertain.cache.ICacheReader;
import uncertain.cache.ICacheWriter;
import uncertain.cache.INamedCacheFactory;
import uncertain.core.ILifeCycle;
import uncertain.ocm.IConfigureListener;

public class XmemcachedClientFactory
implements INamedCacheFactory,
IConfigureListener,
ILifeCycle {
    MemcachedClient mClient;
    String mServerList;
    MemcachedClientWrapper mDefaultWrapper;
    String mName;
    int operationTimeout;
    boolean addNameToKey;

    private MemcachedClientWrapper createWrapper(String name) {
        XmemcachedClientWrapper wrapper = new XmemcachedClientWrapper(name, this.mClient);
        return wrapper;
    }

    public String getServerList() {
        return this.mServerList;
    }

    public void setServerList(String serverList) {
        this.mServerList = serverList;
    }

    public ICacheReader getCacheReader() {
        return this.mDefaultWrapper;
    }

    public ICacheWriter getCacheWriter() {
        return this.mDefaultWrapper;
    }

    public ICache getCache() {
        return this.mDefaultWrapper;
    }

    public String getName() {
        return this.mName;
    }

    public void setName(String name) {
        this.mName = name;
    }

    public boolean isCacheEnabled(String name) {
        return true;
    }

    public ICache getNamedCache(String name) {
        return this.createWrapper(name);
    }

    public void endConfigure() {
        this.startup();
    }

    public boolean startup() {
        try {
            XMemcachedClientBuilder builder = new XMemcachedClientBuilder(AddrUtil.getAddresses((String)this.mServerList));
            this.mClient = builder.build();
            this.mDefaultWrapper = this.createWrapper(null);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            throw new RuntimeException(ex);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        if (this.mClient != null) {
            try {
                this.mClient.shutdown();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                this.mClient = null;
                this.mDefaultWrapper = null;
            }
        }
    }

    public void setNamedCache(String name, ICache cache) {
    }
}

