/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.script;

import aurora.application.action.ActionUtil;
import aurora.plugin.script.engine.InterruptException;
import aurora.plugin.script.engine.ScriptRunner;
import javax.script.ScriptException;
import org.mozilla.javascript.RhinoException;
import uncertain.composite.CompositeMap;
import uncertain.ocm.IObjectRegistry;
import uncertain.ocm.OCManager;
import uncertain.proc.AbstractEntry;
import uncertain.proc.ProcedureRunner;

public class ServerScript
extends AbstractEntry {
    String jsimport;
    String exp = null;
    String resultpath = null;
    String cdata = null;
    String optimizeLevel = null;
    int lineno = -1;
    private IObjectRegistry registry;

    public ServerScript(OCManager oc_manager, IObjectRegistry registry) {
        this.registry = registry;
    }

    public String getResultpath() {
        return this.resultpath;
    }

    public void setResultpath(String resultpath) {
        this.resultpath = resultpath;
    }

    public String getExp() {
        return this.exp;
    }

    public void setExp(String exp) {
        this.exp = exp;
    }

    public String getImport() {
        return this.jsimport;
    }

    public void setImport(String import1) {
        this.jsimport = import1;
    }

    public String getOptimizeLevel() {
        return this.optimizeLevel;
    }

    public void setOptimizeLevel(String optimizeLevel) {
        this.optimizeLevel = optimizeLevel;
    }

    public void run(ProcedureRunner runner) throws Exception {
        CompositeMap context = runner.getContext();
        if (this.exp == null) {
            this.exp = this.cdata;
        }
        try {
            ScriptRunner sr = new ScriptRunner(this.exp, context, this.registry);
            sr.setImport(this.jsimport);
            sr.setProcedureRunner(runner);
            sr.setOptimizeLevel(this.optimizeLevel);
            Object res = sr.run();
            if (this.resultpath != null) {
                context.putObject(this.resultpath, res, true);
            }
        }
        catch (InterruptException ie) {
            ActionUtil.raiseApplicationError((ProcedureRunner)runner, (IObjectRegistry)this.registry, (String)ie.getMessage());
        }
        catch (RhinoException re) {
            String srcName = re.sourceName();
            int line = re.lineNumber();
            if ("<Unknown source>".equals(srcName)) {
                line += this.lineno - 1;
            }
            StringBuilder sb = new StringBuilder(500);
            sb.append("\n");
            sb.append("source  : " + this.source + " --> " + srcName + "\n");
            sb.append("lineno  : " + line + "\n");
            sb.append("line src: " + re.lineSource() + "\n");
            sb.append("message : " + re.getMessage() + "\n");
            throw new ScriptException(sb.toString());
        }
    }

    public void beginConfigure(CompositeMap config) {
        super.beginConfigure(config);
        this.lineno = config.getLocationNotNull().getStartLine();
        this.cdata = config.getText();
        if (this.cdata == null) {
            this.cdata = "";
        }
    }
}

