/*
 * Decompiled with CFR 0.152.
 */
package aurora.database;

import aurora.bm.BusinessModel;
import aurora.bm.Field;
import aurora.database.FetchDescriptor;
import aurora.database.IResultSetConsumer;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import uncertain.datatype.DataType;
import uncertain.datatype.DataTypeRegistry;

public class ResultSetLoader {
    String rootName = "records";
    String elementName = "record";
    DataTypeRegistry datatypeRegistry = DataTypeRegistry.getInstance();
    byte fieldNameCase = 0;

    public ResultSetLoader() {
    }

    public ResultSetLoader(DataTypeRegistry registry) {
        this.datatypeRegistry = registry;
    }

    String getFieldName(String name) {
        String key = null;
        if (name != null) {
            key = this.fieldNameCase == 1 ? name.toUpperCase() : (this.fieldNameCase == 2 ? name.toLowerCase() : name);
        }
        return key;
    }

    void fetchRowByMetaData(ResultSet rs, ResultSetMetaData meta, IResultSetConsumer consumer) throws SQLException {
        consumer.newRow(this.elementName);
        for (int i = 1; i <= meta.getColumnCount(); ++i) {
            String name = meta.getColumnName(i);
            name = this.getFieldName(name);
            Object value = rs.getObject(i);
            consumer.loadField(name, value);
        }
        consumer.endRow();
    }

    void fetchRowByStructure(ResultSet rs, BusinessModel struct, IResultSetConsumer consumer) throws SQLException {
        consumer.newRow(this.elementName);
        Field[] fields = struct.getFields();
        DataType[] types = struct.getFieldTypeArray(this.datatypeRegistry);
        if (fields == null) {
            throw new IllegalArgumentException("Can't get fields from model");
        }
        for (int i = 0; i < fields.length; ++i) {
            String name;
            if (!fields[i].isForSelect()) continue;
            Field fld = fields[i];
            if (fld.isReferenceField()) {
                fld = fld.getReferredField();
            }
            if ((name = this.getFieldName(fields[i].getName())) == null) {
                throw new IllegalArgumentException("must specify name property in field config: " + fields[i].getObjectContext().toXML());
            }
            String physical_name = fields[i].getName();
            DataType type = types[i];
            Object value = null;
            try {
                value = type != null ? type.getObject(rs, rs.findColumn(physical_name)) : rs.getObject(physical_name);
            }
            catch (Throwable ex) {
                throw new SQLException("can't load value for field No. " + (i + 1) + ", named '" + fld.getName() + "':" + ex.getClass().getName() + " " + ex.getMessage());
            }
            consumer.loadField(name, value);
        }
        consumer.endRow();
    }

    public void loadByResultSet(ResultSet rs, FetchDescriptor desc, IResultSetConsumer consumer) throws SQLException {
        ResultSetMetaData meta = rs.getMetaData();
        consumer.begin(this.rootName);
        if (desc.fetchAll) {
            while (rs.next()) {
                this.fetchRowByMetaData(rs, meta, consumer);
            }
        } else {
            if (!desc.locate(rs)) {
                return;
            }
            for (int i = 0; i < desc.getPageSize(); ++i) {
                this.fetchRowByMetaData(rs, meta, consumer);
                if (rs.next()) {
                    continue;
                }
                break;
            }
        }
        consumer.end();
    }

    public void loadByConfig(ResultSet rs, FetchDescriptor desc, BusinessModel meta, IResultSetConsumer consumer) throws SQLException {
        consumer.begin(this.rootName);
        if (desc.fetchAll) {
            while (rs.next()) {
                this.fetchRowByStructure(rs, meta, consumer);
            }
        } else {
            if (!desc.locate(rs)) {
                return;
            }
            for (int i = 0; i < desc.getPageSize(); ++i) {
                this.fetchRowByStructure(rs, meta, consumer);
                if (rs.next()) {
                    continue;
                }
                break;
            }
        }
        consumer.end();
    }

    public byte getFieldNameCase() {
        return this.fieldNameCase;
    }

    public void setFieldNameCase(byte fieldNameCase) {
        this.fieldNameCase = fieldNameCase;
    }

    public String getElementName() {
        return this.elementName;
    }

    public void setElementName(String elementName) {
        this.elementName = elementName;
    }
}

