/*
 * Decompiled with CFR 0.152.
 */
package aurora.database.service;

import aurora.database.DBUtil;
import aurora.database.FetchDescriptor;
import aurora.database.IResultSetConsumer;
import aurora.database.ParsedSql;
import aurora.database.SqlRunner;
import aurora.database.service.ServiceOption;
import aurora.datasource.DataSourceConfig;
import aurora.datasource.DatabaseConnection;
import aurora.datasource.INamedDataSourceProvider;
import aurora.datasource.NamedDataSourceProvider;
import aurora.service.ServiceContext;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import javax.sql.DataSource;
import uncertain.composite.CompositeMap;
import uncertain.composite.DynamicObject;
import uncertain.composite.ICompositeAccessor;
import uncertain.logging.ILogger;
import uncertain.logging.LoggingContext;
import uncertain.ocm.IObjectRegistry;

public class SqlServiceContext
extends ServiceContext {
    public static final String KEY_RESULTSET_CONSUMER = "ResultsetConsumer";
    public static final String KEY_FETCH_DESCRIPTOR = "FetchDescriptor";
    public static final String KEY_SQL_STRING = "SqlString";
    public static final String KEY_DATABASE_CONNECTION = "__database_connection";
    public static final String KEY_DATABASE_ALL_CONNECTION = "__database_all_connection";
    public static final String KEY_SERVICE_OPTION = "__database_service_option";

    public static SqlServiceContext createSqlServiceContext(CompositeMap context_map) {
        SqlServiceContext context = new SqlServiceContext();
        context.initialize(context_map);
        return context;
    }

    public static SqlServiceContext createSqlServiceContext(Connection conn) {
        CompositeMap map = new CompositeMap("sql-service");
        SqlServiceContext context = SqlServiceContext.createSqlServiceContext(map);
        context.setConnection(conn);
        return context;
    }

    public DataSource getContextDataSource() {
        return (DataSource)this.getInstanceOfType(DataSource.class);
    }

    public Set getAllConnection() {
        return (HashSet)super.get(KEY_DATABASE_ALL_CONNECTION);
    }

    private void addConnection(Connection conn) {
        HashSet<Connection> databaseAllConnection = this.getAllConnection();
        if (databaseAllConnection == null) {
            databaseAllConnection = new HashSet<Connection>();
            super.put(KEY_DATABASE_ALL_CONNECTION, databaseAllConnection);
        }
        databaseAllConnection.add(conn);
    }

    public void setConnection(Connection conn) {
        this.setInstanceOfType(Connection.class, conn);
        this.addConnection(conn);
    }

    public Connection getConnection() {
        return (Connection)this.getInstanceOfType(Connection.class);
    }

    public void setNamedConnection(String name, Connection conn) {
        String key = "__database_connection." + name;
        super.put(key, conn);
        this.addConnection(conn);
    }

    public Connection getNamedConnection(String name) throws SQLException {
        String key = "__database_connection." + name;
        return name == null ? (Connection)this.getInstanceOfType(Connection.class) : (Connection)super.get(key);
    }

    public ICompositeAccessor getCompositeAccessor() {
        return (ICompositeAccessor)this.getInstanceOfType(ICompositeAccessor.class);
    }

    public void setCompositeAccessor(ICompositeAccessor compositeAccessor) {
        this.setInstanceOfType(ICompositeAccessor.class, compositeAccessor);
    }

    public ServiceOption getServiceOption() {
        Object obj = this.get(KEY_SERVICE_OPTION);
        if (obj instanceof ServiceOption) {
            return (ServiceOption)obj;
        }
        if (obj instanceof CompositeMap) {
            return (ServiceOption)DynamicObject.cast((CompositeMap)obj, ServiceOption.class);
        }
        return null;
    }

    public void setServiceOption(ServiceOption opt) {
        this.put(KEY_SERVICE_OPTION, opt);
    }

    public IResultSetConsumer getResultsetConsumer() {
        return (IResultSetConsumer)this.get(KEY_RESULTSET_CONSUMER);
    }

    public void setResultsetConsumer(IResultSetConsumer consumer) {
        this.put(KEY_RESULTSET_CONSUMER, consumer);
    }

    public FetchDescriptor getFetchDescriptor() {
        return (FetchDescriptor)this.get(KEY_FETCH_DESCRIPTOR);
    }

    public void setFetchDescriptor(FetchDescriptor desc) {
        this.put(KEY_FETCH_DESCRIPTOR, desc);
    }

    public StringBuffer getSqlString() {
        return (StringBuffer)this.get(KEY_SQL_STRING);
    }

    public void setSqlString(StringBuffer sql) {
        this.put(KEY_SQL_STRING, sql);
    }

    public void initConnection(IObjectRegistry reg, String datasourceName) throws SQLException {
        ILogger mLogger = LoggingContext.getLogger("aurora.database.service", reg);
        if (datasourceName == null) {
            Connection conn = this.getConnection();
            if (conn == null) {
                DataSource ds = (DataSource)reg.getInstanceOfType(DataSource.class);
                if (ds == null) {
                    mLogger.log(Level.SEVERE, "No DataSource instance configured in engine");
                    throw new IllegalStateException("No DataSource instance configured in engine");
                }
                conn = ds.getConnection();
                if (conn.getAutoCommit()) {
                    conn.setAutoCommit(false);
                }
                this.setConnection(conn);
                this.connectionInitialize(reg, datasourceName);
            }
        } else {
            Connection conn = this.getNamedConnection(datasourceName);
            if (conn == null) {
                NamedDataSourceProvider dsProvider = (NamedDataSourceProvider)reg.getInstanceOfType(INamedDataSourceProvider.class);
                if (dsProvider == null) {
                    mLogger.log(Level.SEVERE, "No NamedDataSourceProvider instance not configured in engine");
                    throw new IllegalStateException("No NamedDataSourceProvider instance not configured in engine");
                }
                DataSource ds = dsProvider.getDataSource(datasourceName);
                if (ds == null) {
                    mLogger.log(Level.SEVERE, "DataSource instance named \"" + datasourceName + "\" not configured in engine");
                    throw new IllegalStateException("DataSource instance named \"" + datasourceName + "\" not configured in engine");
                }
                conn = ds.getConnection();
                if (conn.getAutoCommit()) {
                    conn.setAutoCommit(false);
                }
                this.setNamedConnection(datasourceName, conn);
                this.connectionInitialize(reg, datasourceName);
            }
        }
    }

    public void connectionInitialize(IObjectRegistry reg, String dsName) throws SQLException {
        DatabaseConnection[] databaseConnections;
        String initSql = null;
        DataSourceConfig dataSourceconfig = (DataSourceConfig)reg.getInstanceOfType(DataSourceConfig.class);
        for (DatabaseConnection dataBaseConifg : databaseConnections = dataSourceconfig.getDatabaseConnections()) {
            String dataBaseName = dataBaseConifg.getName();
            if (null == dsName && null == dataBaseName) {
                initSql = dataBaseConifg.getInitSql();
                break;
            }
            if (null == dsName || !dsName.equals(dataBaseName)) continue;
            initSql = dataBaseConifg.getInitSql();
            break;
        }
        if (null == initSql) {
            return;
        }
        ParsedSql stmt = new ParsedSql();
        stmt.parse(initSql);
        SqlRunner exits_runner = new SqlRunner(this, stmt);
        exits_runner.setConnectionName(dsName);
        exits_runner.update(this.getParameter());
    }

    public void freeConnection() throws SQLException {
        Set databaseAllConnection = this.getAllConnection();
        if (databaseAllConnection != null) {
            for (Connection conn : databaseAllConnection) {
                DBUtil.closeConnection(conn);
            }
        }
        this.setInstanceOfType(Connection.class, null);
    }
}

