/*
 * Decompiled with CFR 0.152.
 */
package aurora.service.http;

import aurora.bm.BusinessModel;
import aurora.database.service.DatabaseServiceFactory;
import aurora.service.http.WebContextInit;
import aurora.service.ws.WSDLGenerator;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import uncertain.composite.XMLOutputter;
import uncertain.core.UncertainEngine;
import uncertain.ocm.IObjectRegistry;

public class WSDLServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    public static final String SERVLET_NAME = "wsdl";
    DatabaseServiceFactory mDatabaseServiceFactory;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        ServletContext context = config.getServletContext();
        UncertainEngine uncertainEngine = WebContextInit.getUncertainEngine(context);
        if (uncertainEngine == null) {
            throw new ServletException("Uncertain engine not initialized");
        }
        IObjectRegistry reg = uncertainEngine.getObjectRegistry();
        if (reg == null) {
            throw new ServletException("IObjectRegistry not initialized");
        }
        this.mDatabaseServiceFactory = (DatabaseServiceFactory)reg.getInstanceOfType(DatabaseServiceFactory.class);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String multi;
        BusinessModel bm;
        String uri = request.getRequestURI();
        String[] args = uri.split("/");
        if (args.length < 4) {
            throw new ServletException("Invalid request format");
        }
        int start_index = 0;
        for (int i = 0; i < args.length; ++i) {
            String tmp = args[i];
            if (!SERVLET_NAME.equals(tmp)) continue;
            start_index = i;
            break;
        }
        String object_name = args[start_index + 1];
        String operation_name = null;
        if (start_index + 2 < args.length) {
            operation_name = args[start_index + 2];
        }
        if ((bm = this.mDatabaseServiceFactory.getModelFactory().getModelForRead(object_name)) == null) {
            throw new ServletException("Can't load model:" + object_name);
        }
        String fullUrl = this.getFullUrl(request);
        WSDLGenerator wsdl = operation_name == null ? new WSDLGenerator(bm, fullUrl) : ("query".equalsIgnoreCase(operation_name) ? ("Y".equalsIgnoreCase(multi = request.getParameter("multi_flag")) ? new WSDLGenerator(bm, fullUrl, true) : new WSDLGenerator(bm, fullUrl, false)) : new WSDLGenerator(bm, fullUrl, operation_name));
        response.setContentType("text/plain;charset=UTF-8");
        PrintWriter out = response.getWriter();
        try {
            String content = XMLOutputter.defaultInstance().toXML(wsdl.run(), true);
            out.print(content);
            out.flush();
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    private String getFullUrl(HttpServletRequest request) {
        StringBuffer url = request.getRequestURL();
        if (request.getQueryString() != null) {
            url.append("?");
            url.append(request.getQueryString());
        }
        String request_url = url.toString();
        String autocrud = request_url.replace(SERVLET_NAME, "autocrud");
        return autocrud;
    }
}

