/*
 * Decompiled with CFR 0.152.
 */
package aurora.service.validation;

import java.util.Locale;
import java.util.ResourceBundle;
import uncertain.composite.CompositeMap;
import uncertain.composite.DynamicObject;

public class ErrorMessage
extends DynamicObject {
    public static final String ERROR_MESSAGE = "error-message";
    public static final String KEY_MESSAGE = "message";
    public static final String KEY_CODE = "code";
    public static final String KEY_FIELD = "field";
    public static final String KEY_INPUT = "input";
    public static final String KEY_ERRORS = "errors";

    public ErrorMessage() {
    }

    public static ErrorMessage createErrorMessage(CompositeMap context) {
        ErrorMessage msg = new ErrorMessage();
        msg.initialize(context);
        return msg;
    }

    public ErrorMessage(String code, String message, String field) {
        CompositeMap m = new CompositeMap(10);
        m.setName(ERROR_MESSAGE);
        this.initialize(m);
        this.setField(field);
        this.setCode(code);
        this.setMessage(message);
    }

    public void localize(Locale locale, ResourceBundle bundle) {
    }

    public String getCode() {
        return this.getString(KEY_CODE);
    }

    public void setCode(String code) {
        this.put(KEY_CODE, code);
    }

    public String getMessage() {
        return this.getString(KEY_MESSAGE);
    }

    public void setMessage(String message) {
        this.put(KEY_MESSAGE, message);
    }

    public String getField() {
        return this.getString(KEY_FIELD);
    }

    public void setField(String field) {
        this.put(KEY_FIELD, field);
    }

    public CompositeMap getInput() {
        return (CompositeMap)this.get(KEY_INPUT);
    }

    public void setInput(CompositeMap input) {
        input.setParent(this.getObjectContext());
        this.put(KEY_INPUT, input);
    }

    public CompositeMap getErrors() {
        CompositeMap child = this.getObjectContext().getChild(KEY_ERRORS);
        if (child == null) {
            child = this.getObjectContext().createChild(KEY_ERRORS);
        }
        return child;
    }

    public void addErrorMessage(CompositeMap error) {
        this.getErrors().addChild(error);
    }

    public void addErrorMessage(ErrorMessage msg) {
        this.getErrors().addChild(msg.getObjectContext());
    }
}

