/*
 * Decompiled with CFR 0.152.
 */
package aurora.service.ws;

import aurora.bm.BusinessModel;
import aurora.bm.Field;
import aurora.service.validation.Parameter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Clob;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import uncertain.composite.CompositeMap;
import uncertain.ocm.OCManager;
import uncertain.schema.Namespace;

public class WSDLGenerator {
    private BusinessModel model;
    private String location;
    private boolean queryMutiRecords = true;
    private static HashMap<String, String> xsdMap = new HashMap();
    private String[] operations;
    private static final String TARGET_NAMESPACE = "http://www.aurora-framework.org/schema";
    private static final String TARGET_PREFIX = "tns";
    private static final Namespace xsd = new Namespace("xsd", "http://www.w3.org/2001/XMLSchema");
    private static final Namespace soap = new Namespace("soap", "http://schemas.xmlsoap.org/wsdl/soap/");
    private static final Namespace wsdl = new Namespace("wsdl", "http://schemas.xmlsoap.org/wsdl/");
    private static final Namespace tns = new Namespace("tns", "http://www.aurora-framework.org/schema");

    public WSDLGenerator(BusinessModel model, String location) {
        this.model = model;
        this.location = location;
        this.operations = new String[]{"query", "delete", "execute", "insert", "update"};
    }

    public WSDLGenerator(BusinessModel model, String location, String operation) {
        this.model = model;
        this.location = location;
        this.operations = new String[]{operation};
    }

    public WSDLGenerator(BusinessModel model, String location, boolean queryMutiRecords) {
        this.model = model;
        this.location = location;
        this.operations = new String[]{"query"};
        this.queryMutiRecords = queryMutiRecords;
    }

    public CompositeMap run() {
        CompositeMap wsdlRoot = this.getWSDLTemplate(this.model.getName(), this.location);
        for (int i = 0; i < this.operations.length; ++i) {
            Orient orient = new Orient();
            this.createTypes(wsdlRoot, this.operations[i], orient);
            if (orient.hasRequestType) {
                this.createMessage(wsdlRoot, this.operations[i], true);
            }
            if (orient.hasResponseType) {
                this.createMessage(wsdlRoot, this.operations[i], false);
            }
            this.createOpertaion(wsdlRoot, this.operations[i], orient);
            this.createBindingOpertaion(wsdlRoot, this.operations[i], orient);
        }
        return wsdlRoot;
    }

    private void createOpertaion(CompositeMap wsdlRoot, String operation, Orient orient) {
        CompositeMap oper = this.getWSDLNode("operation");
        oper.put("name", operation);
        if (orient.hasRequestType) {
            CompositeMap input = this.getWSDLNode("input");
            input.put("message", "tns:" + this.createName(operation, true, WSDL_TYPES.message));
            oper.addChild(input);
        }
        if (orient.hasResponseType) {
            CompositeMap output = this.getWSDLNode("output");
            output.put("message", "tns:" + this.createName(operation, false, WSDL_TYPES.message));
            oper.addChild(output);
        }
        if (oper.getChilds() != null) {
            wsdlRoot.getChild("portType").addChild(oper);
        }
    }

    private void createBindingOpertaion(CompositeMap wsdlRoot, String operation, Orient orient) {
        CompositeMap body;
        if (!orient.hasRequestType && !orient.hasResponseType) {
            return;
        }
        CompositeMap oper = this.getWSDLNode("operation");
        CompositeMap soap = this.getSOAPNode("operation");
        soap.put("soapAction", operation);
        oper.addChild(soap);
        oper.put("name", operation);
        if (orient.hasRequestType) {
            CompositeMap input = this.getWSDLNode("input");
            body = this.getSOAPNode("body");
            body.put("use", "literal");
            input.addChild(body);
            oper.addChild(input);
        }
        if (orient.hasResponseType) {
            CompositeMap output = this.getWSDLNode("output");
            body = this.getSOAPNode("body");
            body.put("use", "literal");
            output.addChild(body);
            oper.addChild(output);
        }
        wsdlRoot.getChild("binding").addChild(oper);
    }

    private void createMessage(CompositeMap wsdlRoot, String operation, boolean isRequest) {
        CompositeMap message = this.getWSDLNode("message");
        message.put("name", this.createName(operation, isRequest, WSDL_TYPES.message));
        CompositeMap part = this.getWSDLNode("part");
        part.put("name", this.createName(operation, isRequest, WSDL_TYPES.part));
        if ("query".equals(operation) && !isRequest) {
            if (this.queryMutiRecords) {
                part.put("element", "tns:records");
            } else {
                part.put("element", "tns:record");
            }
        } else {
            part.put("element", "tns:" + this.createName(operation, isRequest, WSDL_TYPES.type));
        }
        message.addChild(part);
        int index = wsdlRoot.getChilds().indexOf(wsdlRoot.getChild("types"));
        wsdlRoot.addChild(index + 1, message);
    }

    private CompositeMap getWSDLTemplate(String modelName, String location) {
        CompositeMap wsdlRoot = new CompositeMap(wsdl.getPrefix(), wsdl.getUrl(), "definitions");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(tns.getUrl(), tns.getPrefix());
        wsdlRoot.setNamespaceMapping(map);
        wsdlRoot.put("name", modelName);
        wsdlRoot.put("targetNamespace", TARGET_NAMESPACE);
        CompositeMap types = new CompositeMap(wsdl.getPrefix(), wsdl.getUrl(), "types");
        CompositeMap schema = new CompositeMap(xsd.getPrefix(), xsd.getUrl(), "schema");
        schema.put("targetNamespace", TARGET_NAMESPACE);
        types.addChild(schema);
        wsdlRoot.addChild(types);
        CompositeMap portType = new CompositeMap(wsdl.getPrefix(), wsdl.getUrl(), "portType");
        portType.put("name", modelName + "_" + (Object)((Object)WSDL_TYPES.portType));
        wsdlRoot.addChild(portType);
        CompositeMap binding = new CompositeMap(wsdl.getPrefix(), wsdl.getUrl(), "binding");
        binding.put("name", modelName + "_" + (Object)((Object)WSDL_TYPES.binding));
        binding.put("type", "tns:" + modelName + "_" + (Object)((Object)WSDL_TYPES.portType));
        CompositeMap transport = new CompositeMap(soap.getPrefix(), soap.getUrl(), "binding");
        transport.put("style", "document");
        transport.put("transport", "http://schemas.xmlsoap.org/soap/http");
        binding.addChild(transport);
        wsdlRoot.addChild(binding);
        CompositeMap service = new CompositeMap(wsdl.getPrefix(), wsdl.getUrl(), "service");
        service.put("name", modelName + "_" + (Object)((Object)WSDL_TYPES.service));
        CompositeMap port = new CompositeMap(wsdl.getPrefix(), wsdl.getUrl(), "port");
        port.put("name", modelName + "_" + (Object)((Object)WSDL_TYPES.port));
        port.put("binding", "tns:" + modelName + "_" + (Object)((Object)WSDL_TYPES.binding));
        service.addChild(port);
        CompositeMap address = new CompositeMap(soap.getPrefix(), soap.getUrl(), "address");
        address.put("location", location);
        port.addChild(address);
        wsdlRoot.addChild(service);
        return wsdlRoot;
    }

    private void createTypes(CompositeMap wsdlRoot, String operation, Orient orient) {
        LinkedList<Parameter> parameters = this.model.getParameterForOperationInList(operation);
        CompositeMap request = this.getXSDCtElement("element");
        request.put("name", this.createName(operation, true, WSDL_TYPES.type));
        if ("query".equals(operation)) {
            CompositeMap response;
            if (this.queryMutiRecords) {
                response = this.getMutiRecord();
            } else {
                response = this.getXSDCtElement("element");
                response.put("name", "record");
            }
            Field[] fields = this.model.getFields();
            if (parameters == null && fields == null) {
                return;
            }
            if (parameters == null) {
                parameters = new LinkedList<Parameter>();
            }
            if (fields != null) {
                OCManager mOcManager = OCManager.getInstance();
                Parameter param = null;
                for (int i = 0; i < fields.length; ++i) {
                    Field field = fields[i];
                    param = new Parameter();
                    CompositeMap m = field.getObjectContext();
                    mOcManager.populateObject(m, param);
                    param.setOutput(true);
                    param.setInput(false);
                    parameters.add(param);
                }
            }
            this.interpretParameters(wsdlRoot, orient, parameters, request, response);
            return;
        }
        if (parameters == null) {
            return;
        }
        CompositeMap response = this.getXSDCtElement("element");
        response.put("name", this.createName(operation, false, WSDL_TYPES.type));
        this.interpretParameters(wsdlRoot, orient, parameters, request, response);
    }

    private void interpretParameters(CompositeMap wsdlRoot, Orient orient, List<Parameter> parameters, CompositeMap request, CompositeMap response) {
        Iterator<Parameter> paraIts = parameters.iterator();
        HashSet<String> inputParameters = new HashSet<String>();
        HashSet<String> outputParameters = new HashSet<String>();
        while (paraIts.hasNext()) {
            Parameter para = paraIts.next();
            if (para.getInput()) {
                orient.hasRequestType = true;
                if (inputParameters.contains(para.getName())) continue;
                inputParameters.add(para.getName());
                this.addXSDAttribute(request, para.getName(), para.getDataType());
            }
            if (!para.getOutput()) continue;
            orient.hasResponseType = true;
            if (outputParameters.contains(para.getName())) continue;
            outputParameters.add(para.getName());
            this.addXSDAttribute(response, para.getName(), para.getDataType());
        }
        CompositeMap schema = (CompositeMap)wsdlRoot.getObject("/types/schema");
        if (orient.hasRequestType) {
            schema.addChild(request);
        }
        if (orient.hasResponseType) {
            schema.addChild(response.getRoot());
        }
    }

    private String createName(String operation, boolean isRequest, WSDL_TYPES types) {
        return operation + (isRequest ? "Request" : "Response") + (Object)((Object)types);
    }

    private CompositeMap getMutiRecord() {
        CompositeMap records = this.getXSDNode("element");
        records.put("name", "records");
        CompositeMap complexType = this.getXSDNode("complexType");
        records.addChild(complexType);
        CompositeMap sequence = this.getXSDNode("sequence");
        complexType.addChild(sequence);
        CompositeMap record = this.getXSDNode("element");
        sequence.addChild(record);
        record.put("maxOccurs", "unbounded");
        record.put("name", "record");
        CompositeMap type = this.getXSDNode("complexType");
        record.addChild(type);
        return record;
    }

    private CompositeMap getXSDNode(String name) {
        return new CompositeMap(xsd.getPrefix(), xsd.getUrl(), name);
    }

    private CompositeMap getWSDLNode(String name) {
        return new CompositeMap(wsdl.getPrefix(), wsdl.getUrl(), name);
    }

    private CompositeMap getSOAPNode(String name) {
        return new CompositeMap(soap.getPrefix(), soap.getUrl(), name);
    }

    private CompositeMap getXSDCtElement(String name) {
        CompositeMap element = this.getXSDNode("element");
        CompositeMap complexType = this.getXSDNode("complexType");
        element.addChild(complexType);
        return element;
    }

    private void addXSDAttribute(CompositeMap element, String name, String javaType) {
        CompositeMap complexType = element.getChild("complexType");
        CompositeMap atttribute = this.getXSDNode("attribute");
        atttribute.put("name", name);
        String type = xsdMap.get(javaType);
        if (type == null) {
            throw new RuntimeException(javaType + " is not defined the map type");
        }
        atttribute.put("type", type);
        complexType.addChild(atttribute);
    }

    static {
        xsdMap.put(String.class.getCanonicalName(), xsd.getPrefix() + ":string");
        xsdMap.put(Byte.TYPE.getCanonicalName(), xsd.getPrefix() + ":byte");
        xsdMap.put(Short.TYPE.getCanonicalName(), xsd.getPrefix() + ":short");
        xsdMap.put(Integer.TYPE.getCanonicalName(), xsd.getPrefix() + ":int");
        xsdMap.put(Long.TYPE.getCanonicalName(), xsd.getPrefix() + ":long");
        xsdMap.put(Long.class.getCanonicalName(), xsd.getPrefix() + ":long");
        xsdMap.put(Float.TYPE.getCanonicalName(), xsd.getPrefix() + ":float");
        xsdMap.put(Double.TYPE.getCanonicalName(), xsd.getPrefix() + ":double");
        xsdMap.put(Double.class.getCanonicalName(), xsd.getPrefix() + ":double");
        xsdMap.put(BigInteger.class.getCanonicalName(), xsd.getPrefix() + ":integer");
        xsdMap.put(BigDecimal.class.getCanonicalName(), xsd.getPrefix() + ":decimal");
        xsdMap.put(Calendar.class.getCanonicalName(), xsd.getPrefix() + ":dateTime");
        xsdMap.put(Date.class.getCanonicalName(), xsd.getPrefix() + ":dateTime");
        xsdMap.put(Clob.class.getCanonicalName(), xsd.getPrefix() + ":string");
    }

    class Orient {
        public boolean hasRequestType;
        public boolean hasResponseType;

        Orient() {
        }
    }

    static enum WSDL_TYPES {
        type,
        message,
        portType,
        binding,
        service,
        part,
        port;

    }
}

