/*
 * Decompiled with CFR 0.152.
 */
package uncertain.composite;

public class QualifiedName {
    String mNameSpace;
    String mPrefix;
    String mLocalName;
    String mInternalName;

    static boolean isEqual(String a, String b) {
        if (a == null || b == null) {
            return a == null && b == null;
        }
        return a.equals(b);
    }

    public QualifiedName(String nameSpace, String name) {
        this(null, nameSpace, name);
    }

    public QualifiedName(String name) {
        this(null, null, name);
    }

    public QualifiedName(String prefix, String namespace, String local_name) {
        assert (local_name != null);
        this.mNameSpace = namespace;
        this.mPrefix = prefix;
        this.mLocalName = local_name;
        this.mInternalName = namespace == null ? local_name : namespace + local_name;
    }

    public String getNameSpace() {
        return this.mNameSpace;
    }

    public void setNameSpace(String nameSpace) {
        this.mNameSpace = nameSpace;
    }

    public String getPrefix() {
        return this.mPrefix;
    }

    public void setPrefix(String prefix) {
        this.mPrefix = prefix;
    }

    public String getLocalName() {
        return this.mLocalName;
    }

    public void setLocalName(String name) {
        this.mLocalName = name;
    }

    public String getFullName() {
        StringBuffer buf = new StringBuffer();
        if (this.mPrefix != null) {
            buf.append(this.mPrefix).append(":");
        }
        buf.append(this.mLocalName);
        return buf.toString();
    }

    public int hashCode() {
        return this.mInternalName.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof QualifiedName) {
            QualifiedName q = (QualifiedName)obj;
            return QualifiedName.isEqual(this.mLocalName, q.mLocalName) && QualifiedName.isEqual(this.mNameSpace, q.mNameSpace);
        }
        return false;
    }

    public String toString() {
        if (this.mNameSpace == null) {
            return this.mLocalName;
        }
        return "{" + this.mNameSpace + "}" + this.mLocalName;
    }
}

