/*
 * Decompiled with CFR 0.152.
 */
package uncertain.ocm;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import uncertain.ocm.MappingRule;
import uncertain.ocm.NamingUtil;
import uncertain.ocm.OCManager;

public class ClassAnalyzer {
    HashMap field_map;
    HashMap method_map = new HashMap();
    OCManager oc_manager;

    public ClassAnalyzer(OCManager _oc_manager) {
        this.field_map = new HashMap();
        this.oc_manager = _oc_manager;
    }

    void prepare() {
        this.field_map.clear();
        this.method_map.clear();
    }

    void addSetterMethod(String name, Method m, boolean from_attribute) {
        MethodPair p = (MethodPair)this.method_map.get(name);
        if (p == null) {
            p = new MethodPair(name);
            this.method_map.put(name, p);
        }
        p.setter = m;
        p.from_attribute = from_attribute;
    }

    void addGetterMethod(String name, Method m) {
        MethodPair p = (MethodPair)this.method_map.get(name);
        if (p == null) {
            p = new MethodPair(name);
            this.method_map.put(name, p);
        }
        p.getter = m;
    }

    public MappingRule analyze(Class type) {
        this.prepare();
        MappingRule rule = new MappingRule(type, this.oc_manager);
        Field[] fields = type.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            Field f = fields[i];
            if (!this.acceptField(f)) continue;
            String name = this.getFieldMappedName(f);
            rule.addMapping(name, f, true);
        }
        Method[] methods = type.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            String name;
            Method m = methods[i];
            if (!this.acceptMethod(m) || (name = m.getName()).length() <= 3) continue;
            String prefix = name.substring(0, 3);
            String mapped_name = this.getMethodMappedName(m);
            if (this.isGetMethod(m)) {
                if (!prefix.equals("get")) continue;
                this.addGetterMethod(mapped_name, m);
                continue;
            }
            if (!this.isSetMethod(m)) continue;
            if (prefix.equals("set")) {
                this.addSetterMethod(mapped_name, m, true);
                continue;
            }
            if (!prefix.equals("add")) continue;
            this.addSetterMethod(mapped_name, m, false);
        }
        for (MethodPair p : this.method_map.values()) {
            if (p.setter == null || p.getter == null && !"add".equals(p.setter.getName().substring(0, 3))) continue;
            try {
                rule.addMapping(p.name, p.setter, p.getter, p.from_attribute);
            }
            catch (IllegalArgumentException ex) {}
        }
        rule.getReady();
        return rule;
    }

    protected String getFieldMappedName(Field f) {
        return NamingUtil.toAttribName(f.getName());
    }

    protected String getMethodMappedName(Method m) {
        return NamingUtil.toAttribName(m.getName().substring(3));
    }

    public boolean acceptField(Field field) {
        int m = field.getModifiers();
        if (Modifier.isStatic(m)) {
            return false;
        }
        return Character.isUpperCase(field.getName().charAt(0));
    }

    public boolean acceptMethod(Method method) {
        int m = method.getModifiers();
        return !Modifier.isStatic(m);
    }

    public boolean isGetMethod(Method m) {
        return m.getParameterTypes().length == 0 && !m.getReturnType().equals(Void.TYPE);
    }

    public boolean isSetMethod(Method m) {
        return m.getParameterTypes().length == 1 && m.getReturnType().equals(Void.TYPE);
    }

    public static class MethodPair {
        Method getter;
        Method setter;
        String name;
        boolean from_attribute = true;

        public MethodPair(String _name) {
            this.name = _name;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append("MethodPair[name:").append(this.name);
            if (this.getter != null) {
                buf.append(" getter:").append(this.getter.getName());
            }
            if (this.setter != null) {
                buf.append(" setter:").append(this.setter.getName());
            }
            buf.append(" from attribute:").append(this.from_attribute).append(']');
            return buf.toString();
        }
    }
}

