/*
 * Decompiled with CFR 0.152.
 */
package uncertain.schema;

import java.util.HashSet;
import java.util.Set;
import uncertain.ocm.IConfigureListener;
import uncertain.schema.ISchemaManager;
import uncertain.schema.ISchemaObject;
import uncertain.schema.Schema;

public abstract class AbstractSchemaObject
implements ISchemaObject,
IConfigureListener {
    ISchemaObject mParent;
    Set mChilds;

    @Override
    public void setParent(ISchemaObject parent) {
        this.mParent = parent;
    }

    @Override
    public ISchemaObject getParent() {
        return this.mParent;
    }

    public ISchemaManager getSchemaManager() {
        Schema schema = this.getSchema();
        return schema == null ? null : schema.getSchemaManager();
    }

    public Schema getSchema() {
        for (ISchemaObject o = this.mParent; o != null; o = o.getParent()) {
            if (!(o instanceof Schema)) continue;
            return (Schema)o;
        }
        return null;
    }

    @Override
    public void doAssemble() {
        if (this.mChilds != null) {
            for (ISchemaObject child : this.mChilds) {
                child.doAssemble();
            }
        }
    }

    public void validate() {
    }

    @Override
    public void endConfigure() {
        this.validate();
    }

    public void addChild(ISchemaObject child) {
        if (this.mChilds == null) {
            this.mChilds = new HashSet();
        }
        child.setParent(this);
        this.mChilds.add(child);
    }

    public void addChilds(ISchemaObject[] childs) {
        for (int i = 0; i < childs.length; ++i) {
            this.addChild(childs[i]);
        }
    }

    public Set getChilds() {
        return this.mChilds;
    }
}

