/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.excelreport;

import aurora.plugin.excelreport.ExcelFactory;
import aurora.plugin.excelreport.SubtotalConfig;
import aurora.plugin.excelreport.TableColumn;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellReference;
import uncertain.composite.CompositeMap;
import uncertain.composite.transform.GroupConfig;
import uncertain.composite.transform.GroupTransformer;
import uncertain.core.UncertainEngine;
import uncertain.ocm.OCManager;

public class DynamicContent {
    int totalCount = -1;
    String cell = "A";
    String dataModel;
    int row = 1;
    CompositeMap columns;
    List<TableColumn> columnList;
    OCManager mOCManager;
    Map<String, TableColumn> columnsMap = new HashMap<String, TableColumn>();
    private int rowIndex = 0;
    private Sheet excelSheet;
    ExcelFactory excelFactory;
    CompositeMap groupMap = new CompositeMap();

    public CompositeMap getGroupMap() {
        return this.groupMap;
    }

    public void createGroupMap() {
        Iterator<TableColumn> iterator = this.columnList.iterator();
        int level = 0;
        LinkedList<SubtotalConfig> list = new LinkedList<SubtotalConfig>();
        while (iterator.hasNext()) {
            TableColumn column = iterator.next();
            SubtotalConfig[] groupConfigs = column.getGroups();
            if (groupConfigs == null) continue;
            for (SubtotalConfig config : groupConfigs) {
                String[] groupFields = config.getGroupField().split(",");
                if (groupFields == null) {
                    throw new RuntimeException("groupField is null");
                }
                for (String groupField : groupFields) {
                    TableColumn groupColumn = this.columnsMap.get(groupField);
                    level = groupColumn.getGroupLevel();
                    if (level == 0) {
                        throw new RuntimeException("groupField:" + groupField + ";groupLevel is null or 0");
                    }
                    CompositeMap record = this.groupMap.getChild("level" + level);
                    SubtotalConfig configClone = new SubtotalConfig();
                    configClone.setGroupDesc(config.getGroupDesc());
                    configClone.setGroupField(config.getGroupField());
                    configClone.setGroupFormula(config.getGroupFormula());
                    configClone.setTotalDesc(config.getTotalDesc());
                    configClone.setGroupStyle(config.getGroupStyle());
                    configClone.setColumnField(column.getField());
                    configClone.setGroupColumnFild(groupColumn.getField());
                    list = (LinkedList<SubtotalConfig>)record.get((Object)"list");
                    if (list == null) {
                        list = new LinkedList<SubtotalConfig>();
                    }
                    list.add(configClone);
                    record.put((Object)"list", list);
                }
            }
        }
    }

    public Map<String, TableColumn> getColumnsMap() {
        return this.columnsMap;
    }

    public void putColumnsMap(String name, TableColumn tableColumn) {
        this.columnsMap.put(name, tableColumn);
    }

    public DynamicContent(UncertainEngine uncertainEngine) {
        this.mOCManager = uncertainEngine.getOcManager();
    }

    public String getCell() {
        return this.cell;
    }

    public void setCell(String cell) {
        this.cell = cell;
    }

    public String getDataModel() {
        return this.dataModel;
    }

    public void setDataModel(String dataModel) {
        this.dataModel = dataModel;
    }

    public int getRow() {
        return this.row;
    }

    public void setRow(int row) {
        this.row = row;
    }

    public CompositeMap getColumns() {
        return this.columns;
    }

    public void setColumns(CompositeMap columns) {
        this.columns = columns;
        this.setTableColumnList(columns);
    }

    public List<TableColumn> getTableColumnList() {
        return this.columnList;
    }

    public void setTableColumnList(CompositeMap columns) {
        Iterator colIt = columns.getChildIterator();
        if (colIt == null) {
            return;
        }
        LinkedList<TableColumn> colList = new LinkedList<TableColumn>();
        while (colIt.hasNext()) {
            CompositeMap colConfig = (CompositeMap)colIt.next();
            TableColumn tableColumn = (TableColumn)this.mOCManager.createObject(colConfig);
            colList.add(tableColumn);
        }
        this.columnList = colList;
    }

    public int createContent(CompositeMap context, ExcelFactory excelFactory, Sheet excelSheet) {
        this.excelSheet = excelSheet;
        this.excelFactory = excelFactory;
        this.createTableTitle(context);
        CompositeMap data = (CompositeMap)context.getObject(this.getDataModel());
        if (data == null) {
            return this.rowIndex;
        }
        GroupConfig[] groupConfig = this.createGroupConfig(data);
        if (groupConfig != null) {
            CompositeMap target = GroupTransformer.transform((CompositeMap)data, (GroupConfig[])groupConfig);
            this.createGroupMap();
            this.createTableGroup(target);
        } else {
            Iterator rowIt = data.getChildIterator();
            if (rowIt == null) {
                return this.rowIndex;
            }
            while (rowIt.hasNext()) {
                CompositeMap record = (CompositeMap)rowIt.next();
                this.createRecord(record);
            }
        }
        return this.rowIndex;
    }

    void createTableTitle(CompositeMap context) {
        List<TableColumn> list = this.getTableColumnList();
        if (list == null) {
            return;
        }
        this.rowIndex = this.getRow();
        Row row = ExcelFactory.createRow(this.excelSheet, this.rowIndex);
        int cellnum = CellReference.convertColStringToIndex((String)this.getCell());
        for (TableColumn column : list) {
            Cell cell = row.createCell(cellnum++);
            this.excelFactory.setCellValue(cell, column.getTitle());
            CellStyle style = this.excelFactory.getStyle(column.getTitleStyle());
            if (!ExcelFactory.isNotNull(style)) continue;
            cell.setCellStyle(style);
        }
        this.excelSheet.createFreezePane(0, this.rowIndex);
    }

    CompositeMap createRecord(CompositeMap record) {
        List<TableColumn> list = this.getTableColumnList();
        if (list == null) {
            return null;
        }
        Row row = ExcelFactory.createRow(this.excelSheet, ++this.rowIndex);
        int cellnum = CellReference.convertColStringToIndex((String)this.getCell());
        for (TableColumn column : list) {
            Cell cell = row.createCell(cellnum++);
            Object value = record.get((Object)column.getField());
            this.excelFactory.setCellValue(cell, value);
            if (column.getCellStyle() == null || "".equals(column.getCellStyle())) continue;
            cell.setCellStyle(this.excelFactory.styles.get(column.getCellStyle()));
        }
        CompositeMap map = new CompositeMap();
        map.put((Object)"rownum", (Object)this.rowIndex);
        map.put((Object)"record", (Object)record);
        return map;
    }

    GroupConfig[] createGroupConfig(CompositeMap dataModel) {
        List<TableColumn> list = this.getTableColumnList();
        Iterator<TableColumn> it = list.iterator();
        TableColumn column = null;
        CompositeMap record = null;
        StringBuffer buffer = null;
        int level = 0;
        int index = CellReference.convertColStringToIndex((String)this.getCell());
        CompositeMap levelMap = new CompositeMap();
        while (it.hasNext()) {
            column = it.next();
            column.setIndex(index);
            this.putColumnsMap(column.getField(), column);
            level = column.getGroupLevel();
            if (level != 0) {
                buffer = (StringBuffer)levelMap.get((Object)level);
                if (buffer == null) {
                    buffer = new StringBuffer();
                }
                if (buffer.length() != 0) {
                    buffer.append(",");
                }
                buffer.append(column.getField());
                levelMap.put((Object)level, (Object)buffer);
            }
            ++index;
        }
        TreeSet keySet = new TreeSet(levelMap.keySet());
        Iterator iterator = keySet.descendingIterator();
        while (iterator.hasNext()) {
            level = (Integer)iterator.next();
            buffer = (StringBuffer)levelMap.get((Object)level);
            record = new CompositeMap("level" + level);
            record.put((Object)"group_key_fields", (Object)buffer.toString());
            record.put((Object)"record_name", (Object)("level" + level));
            this.groupMap.addChild(record);
        }
        if (this.groupMap.getChildIterator() != null) {
            GroupConfig[] configs;
            for (GroupConfig config : configs = GroupConfig.createGroupConfigs((CompositeMap)this.groupMap)) {
                config.setExtendParentAttributes(false);
            }
            return configs;
        }
        return null;
    }

    CompositeMap aaa(List<SubtotalConfig> groupList, List<CompositeMap> rowList, boolean is_total) {
        Map<String, TableColumn> columnMap = this.getColumnsMap();
        Iterator<SubtotalConfig> colIt = groupList.iterator();
        String curGroupFormula = null;
        String curField = null;
        Row row = null;
        LinkedList list = new LinkedList();
        int firstRownum = 0;
        int endRownum = 0;
        boolean is_flag = false;
        boolean is_group = false;
        while (colIt.hasNext()) {
            SubtotalConfig stConfig = colIt.next();
            if (stConfig.getColumnField().equals(curField) || !stConfig.getGroupFormula().equals(curGroupFormula)) {
                curGroupFormula = stConfig.getGroupFormula();
                curField = stConfig.getColumnField();
                row = ExcelFactory.createRow(this.excelSheet, ++this.rowIndex);
                is_flag = true;
                is_group = true;
                if (is_total) {
                    ++this.totalCount;
                }
            }
            if (stConfig.getGroupFormula() != null) {
                TableColumn column = this.getColumnsMap().get(curField);
                Cell cell = row.createCell(column.getIndex());
                StringBuffer colBuffer = new StringBuffer("SUBTOTAL(");
                colBuffer.append(stConfig.getGroupFormula());
                colBuffer.append(",");
                String ref1 = null;
                String ref2 = null;
                Iterator<CompositeMap> iterator = rowList.iterator();
                String value = null;
                boolean is_first = true;
                while (iterator.hasNext()) {
                    CompositeMap map1 = iterator.next();
                    value = ((CompositeMap)map1.get((Object)"record")).getString((Object)stConfig.getGroupColumnFild());
                    if (is_first) {
                        firstRownum = map1.getInt((Object)"rownum");
                        ref1 = CellReference.convertNumToColString((int)cell.getColumnIndex()) + firstRownum;
                        colBuffer.append(ref1);
                        colBuffer.append(":");
                        is_first = false;
                        continue;
                    }
                    endRownum = map1.getInt((Object)"rownum");
                    ref2 = CellReference.convertNumToColString((int)cell.getColumnIndex()) + endRownum;
                }
                if (ref2 == null) {
                    ref2 = ref1;
                    endRownum = firstRownum;
                }
                colBuffer.append(ref2);
                colBuffer.append(")");
                cell.setCellFormula(colBuffer.toString());
                if (is_flag) {
                    String field = stConfig.getGroupColumnFild();
                    TableColumn groupColumn = columnMap.get(field);
                    Cell groupCell = row.createCell(groupColumn.getIndex());
                    if (is_total) {
                        groupCell.setCellValue(stConfig.getTotalDesc());
                    } else {
                        groupCell.setCellValue(value + " " + stConfig.getGroupDesc());
                    }
                    if (ExcelFactory.isNotNull(this.excelFactory.styles.get(stConfig.getGroupStyle()))) {
                        groupCell.setCellStyle(this.excelFactory.styles.get(stConfig.getGroupStyle()));
                    }
                }
            }
            if (!is_group) continue;
            if (!is_total) {
                this.excelSheet.groupRow(firstRownum - 1, this.rowIndex - 2);
            }
            is_group = false;
        }
        if (is_total) {
            CompositeMap map = new CompositeMap();
            map.put((Object)"first", (Object)firstRownum);
            map.put((Object)"end", (Object)endRownum);
            return map;
        }
        return null;
    }

    List<CompositeMap> createTableGroup(CompositeMap dataModel) {
        Iterator it = dataModel.getChildIterator();
        LinkedList<CompositeMap> rowList = new LinkedList<CompositeMap>();
        if (it != null) {
            while (it.hasNext()) {
                CompositeMap childMap = (CompositeMap)it.next();
                if (childMap.getChildIterator() != null) {
                    rowList.addAll(this.createTableGroup(childMap));
                    continue;
                }
                rowList.add(this.createRecord(childMap));
            }
            if (rowList.size() != 0) {
                if (dataModel.getName().startsWith("level")) {
                    String levelName;
                    CompositeMap groupMap = this.getGroupMap();
                    List list = (List)groupMap.getChild(levelName = dataModel.getName()).get((Object)"list");
                    if (list != null) {
                        this.aaa(list, rowList, false);
                    }
                } else {
                    CompositeMap m = null;
                    Iterator iterator = this.groupMap.getChildIterator();
                    while (iterator.hasNext()) {
                        CompositeMap record = (CompositeMap)iterator.next();
                        String levelName = record.getName();
                        List list1 = (List)record.get((Object)"list");
                        m = this.aaa(list1, rowList, true);
                    }
                    int firstRownum = m.getInt((Object)"first");
                    int endRownum = m.getInt((Object)"end");
                    this.excelSheet.groupRow(firstRownum - 1, endRownum + this.totalCount);
                }
            }
        }
        return rowList;
    }
}

