/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.sap.sync.idoc;

import aurora.plugin.sap.sync.idoc.AuroraIDocException;
import aurora.plugin.sap.sync.idoc.IDocFile;
import aurora.plugin.sap.sync.idoc.IDocServer;
import aurora.plugin.sap.sync.idoc.IDocType;
import aurora.plugin.sap.sync.idoc.LoggerUtil;
import java.io.File;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import uncertain.composite.CompositeLoader;
import uncertain.composite.CompositeMap;

public class IDocBackup
extends Thread {
    public static final String SYNC = "sync";
    public IDocServer iDocServer;
    public List errorIdocTypes = new LinkedList();
    public IDocType idocType;

    public IDocBackup(IDocServer iDocServer) {
        this.iDocServer = iDocServer;
    }

    @Override
    public void run() {
        while (this.isServerRunning()) {
            this.idocType = null;
            IDocFile file = this.iDocServer.getBckupFile();
            if (file == null) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    this.iDocServer.log(e);
                }
                continue;
            }
            try {
                int header_id = this.insertInterface(file);
                this.iDocServer.getDbUtil().updateIdocStatus(header_id, file.getIdocId(), "done");
                LoggerUtil.getLogger().log("Idoc File id=" + file.getIdocId() + " execute successful !");
            }
            catch (Throwable e) {
                try {
                    this.iDocServer.log(e);
                    if (this.idocType != null) {
                        this.errorIdocTypes.add(this.idocType);
                    }
                    String errorMessage = "interface failed";
                    LoggerUtil.getLogger().log("updateIdocStatus for idoc:" + file.getIdocId() + " " + errorMessage);
                    this.iDocServer.getDbUtil().updateIdocsStatus(file.getIdocId(), errorMessage);
                }
                catch (Throwable e1) {
                    this.iDocServer.log(e1);
                }
            }
        }
    }

    private int insertInterface(IDocFile file) throws AuroraIDocException {
        File deleteFile;
        int header_id = -1;
        try {
            header_id = this.iDocServer.getDbUtil().existHeaders(file.getIdocId());
            if (header_id != -1) {
                CompositeLoader loader = new CompositeLoader();
                CompositeMap iDocData = loader.loadByFile(file.getPath());
                if (iDocData.getChilds() == null) {
                    int n = header_id;
                    return n;
                }
                this.iDocServer.getDbUtil().setConnectionAutoCommit(false);
                Iterator it = iDocData.getChildIterator();
                while (it.hasNext()) {
                    CompositeMap idoc_node = (CompositeMap)it.next();
                    if (idoc_node == null || idoc_node.getChildIterator() == null || idoc_node.getChilds().size() < 2) {
                        int n = header_id;
                        return n;
                    }
                    CompositeMap control_node = (CompositeMap)idoc_node.getChilds().get(0);
                    if (this.idocType == null) {
                        this.idocType = this.iDocServer.getDbUtil().getIdocType(control_node);
                        if (this.isIdocTypeStop()) {
                            throw new AuroraIDocException("This idocType:" + this.idocType + " has error before");
                        }
                        this.iDocServer.getDbUtil().updateIdocInfo(file.getIdocId(), control_node);
                    }
                    for (int i = 1; i < idoc_node.getChilds().size(); ++i) {
                        CompositeMap content_node = (CompositeMap)idoc_node.getChilds().get(i);
                        this.iDocServer.getDbUtil().registerInterfaceLine(header_id, content_node);
                    }
                }
                this.iDocServer.getDbUtil().getConnection().commit();
            }
        }
        catch (Throwable e) {
            this.iDocServer.getDbUtil().rollbackConnection();
            throw new AuroraIDocException(e);
        }
        finally {
            this.iDocServer.getDbUtil().setConnectionAutoCommit(true);
        }
        if (this.iDocServer.isDeleteFileImmediately() && (deleteFile = new File(file.getPath())).exists()) {
            LoggerUtil.getLogger().log("delete file " + file.getPath() + " " + deleteFile.delete());
        }
        return header_id;
    }

    public boolean isServerRunning() {
        return this.iDocServer.isRunning();
    }

    private boolean isIdocTypeStop() throws SQLException, AuroraIDocException {
        String handleModel = this.iDocServer.getDbUtil().getHandleModel(this.idocType.getIdoctyp(), this.idocType.getCimtyp());
        return SYNC.equals(handleModel) && this.errorIdocTypes.contains(this.idocType);
    }
}

