/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.sap.sync.idoc;

import aurora.plugin.sap.sync.idoc.IDocServer;
import aurora.plugin.sap.sync.idoc.LoggerUtil;

public class ServerConnection
extends Thread {
    private IDocServer iDocServer;
    private int reconnectTime;
    private int maxReconnectTime;
    private int currentConnectTime;

    public ServerConnection(IDocServer iDocServer, int reconnectTime, int maxReconnectTime) {
        this.iDocServer = iDocServer;
        this.reconnectTime = reconnectTime;
        this.maxReconnectTime = maxReconnectTime;
        this.currentConnectTime = reconnectTime;
    }

    @Override
    public void run() {
        while (!this.iDocServer.isShutdownByCommand()) {
            if (this.iDocServer.getJCoIDocServer() == null) {
                this.startServer(false);
                continue;
            }
            if (this.iDocServer.isShutdown()) {
                this.startServer(true);
                continue;
            }
            this.currentConnectTime = this.reconnectTime;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                this.iDocServer.log(e);
            }
        }
    }

    private int computeConnectTime() {
        if (this.currentConnectTime < this.maxReconnectTime) {
            this.currentConnectTime = this.currentConnectTime * 2 <= this.maxReconnectTime ? (this.currentConnectTime *= 2) : this.maxReconnectTime;
        }
        return this.currentConnectTime;
    }

    private void startServer(boolean isRestart) {
        try {
            Thread.sleep(this.computeConnectTime());
        }
        catch (InterruptedException e) {
            this.iDocServer.log(e);
        }
        LoggerUtil.getLogger().log("begin ReConnection IDocServer " + this.iDocServer.getServerName() + "...");
        if (!isRestart) {
            this.iDocServer.start();
        } else {
            this.iDocServer.reStart();
        }
    }
}

