/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.spnego;

import aurora.plugin.spnego.Base64;
import aurora.plugin.spnego.SpnegoAuthScheme;
import aurora.plugin.spnego.SpnegoConfig;
import aurora.plugin.spnego.SpnegoHttpServletResponse;
import aurora.plugin.spnego.SpnegoPrincipal;
import aurora.plugin.spnego.SpnegoProvider;
import java.io.IOException;
import java.security.PrivilegedActionException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.servlet.http.HttpServletRequest;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;

public class SpnegoAuthenticator {
    private static final Lock LOCK = new ReentrantLock();
    private static final GSSManager MANAGER = GSSManager.getInstance();
    private final transient boolean allowBasic;
    private final transient boolean allowDelegation;
    private final transient boolean allowLocalhost;
    private final transient boolean allowUnsecure;
    private final transient boolean promptIfNtlm;
    private final transient String clientModuleName;
    private final transient LoginContext loginContext;
    private final transient GSSCredential serverCredentials;
    private final transient KerberosPrincipal serverPrincipal;

    public SpnegoAuthenticator(SpnegoConfig config) throws LoginException, GSSException, PrivilegedActionException {
        this.allowBasic = config.getAllowBasic();
        this.allowUnsecure = config.getAllowUnsecure();
        this.clientModuleName = config.getClientModuleName();
        this.allowLocalhost = config.getAllowLocalhost();
        this.promptIfNtlm = config.getPromptIfNtlm();
        this.allowDelegation = config.getAllowDelegation();
        CallbackHandler handler = SpnegoProvider.getUsernamePasswordHandler(config.getUsername(), config.getPassword());
        this.loginContext = new LoginContext(config.getServerModuleName(), handler);
        this.loginContext.login();
        this.serverCredentials = SpnegoProvider.getServerCredential(this.loginContext.getSubject());
        this.serverPrincipal = new KerberosPrincipal(((Object)this.serverCredentials.getName()).toString());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SpnegoPrincipal authenticate(HttpServletRequest req, SpnegoHttpServletResponse resp) throws GSSException, IOException {
        boolean basicSupported = this.allowBasic && (this.allowUnsecure || req.isSecure());
        String serverRealm = this.serverPrincipal.getRealm();
        if (this.allowLocalhost && this.isLocalhost(req)) {
            return this.doLocalhost();
        }
        SpnegoAuthScheme scheme = SpnegoProvider.negotiate(req, resp, basicSupported, this.promptIfNtlm, serverRealm);
        if (null == scheme) {
            return null;
        }
        if (scheme.isNegotiateScheme()) {
            return this.doSpnegoAuth(scheme, resp);
        }
        if (!scheme.isBasicScheme()) throw new UnsupportedOperationException("scheme=" + scheme);
        if (!basicSupported) throw new UnsupportedOperationException("Basic Auth not allowed or SSL required.");
        return this.doBasicAuth(scheme, resp);
    }

    public void dispose() {
        if (null != this.serverCredentials) {
            try {
                this.serverCredentials.dispose();
            }
            catch (GSSException e) {
                // empty catch block
            }
        }
        if (null != this.loginContext) {
            try {
                this.loginContext.logout();
            }
            catch (LoginException loginException) {
                // empty catch block
            }
        }
    }

    private SpnegoPrincipal doBasicAuth(SpnegoAuthScheme scheme, SpnegoHttpServletResponse resp) throws IOException {
        byte[] data = scheme.getToken();
        if (0 == data.length) {
            return null;
        }
        String[] basicData = new String(data).split(":", 2);
        if (basicData.length != 2) {
            throw new IllegalArgumentException("Username/Password may have contained an invalid character. basicData.length=" + basicData.length);
        }
        String username = basicData[0].substring(basicData[0].indexOf(92) + 1);
        String password = basicData[1];
        CallbackHandler handler = SpnegoProvider.getUsernamePasswordHandler(username, password);
        SpnegoPrincipal principal = null;
        try {
            if (null == username || username.isEmpty()) {
                throw new LoginException("Username is required.");
            }
            LoginContext cntxt = new LoginContext(this.clientModuleName, handler);
            cntxt.login();
            cntxt.logout();
            principal = new SpnegoPrincipal(username + '@' + this.serverPrincipal.getRealm(), 1);
        }
        catch (LoginException le) {
            resp.setHeader("WWW-Authenticate", "Negotiate");
            resp.addHeader("WWW-Authenticate", "Basic realm=\"" + this.serverPrincipal.getRealm() + '\"');
            resp.setStatus(401, true);
        }
        return principal;
    }

    private SpnegoPrincipal doLocalhost() {
        String username = System.getProperty("user.name");
        if (null == username || username.isEmpty()) {
            return new SpnegoPrincipal(this.serverPrincipal.getName() + '@' + this.serverPrincipal.getRealm(), this.serverPrincipal.getNameType());
        }
        return new SpnegoPrincipal(username + '@' + this.serverPrincipal.getRealm(), 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SpnegoPrincipal doSpnegoAuth(SpnegoAuthScheme scheme, SpnegoHttpServletResponse resp) throws GSSException, IOException {
        String principal;
        byte[] gss = scheme.getToken();
        if (0 == gss.length) {
            return null;
        }
        GSSContext context = null;
        GSSCredential delegCred = null;
        try {
            byte[] token = null;
            LOCK.lock();
            try {
                context = MANAGER.createContext(this.serverCredentials);
                token = context.acceptSecContext(gss, 0, gss.length);
            }
            finally {
                LOCK.unlock();
            }
            if (null == token) {
                SpnegoPrincipal spnegoPrincipal = null;
                return spnegoPrincipal;
            }
            resp.setHeader("WWW-Authenticate", "Negotiate " + Base64.encode(token));
            if (!context.isEstablished()) {
                resp.setStatus(401, true);
                SpnegoPrincipal spnegoPrincipal = null;
                return spnegoPrincipal;
            }
            principal = ((Object)context.getSrcName()).toString();
            if (this.allowDelegation && context.getCredDelegState()) {
                delegCred = context.getDelegCred();
            }
        }
        finally {
            if (null != context) {
                LOCK.lock();
                try {
                    context.dispose();
                }
                finally {
                    LOCK.unlock();
                }
            }
        }
        return new SpnegoPrincipal(principal, 1, delegCred);
    }

    private boolean isLocalhost(HttpServletRequest req) {
        return req.getLocalAddr().equals(req.getRemoteAddr());
    }
}

