/*
 * Decompiled with CFR 0.152.
 */
package aurora.application.features;

import aurora.application.config.ScreenConfig;
import aurora.bm.IModelFactory;
import aurora.database.actions.config.ActionConfigManager;
import aurora.database.actions.config.ModelQueryConfig;
import aurora.events.E_PrepareServiceConfig;
import aurora.presentation.BuildSession;
import aurora.presentation.IViewBuilder;
import aurora.presentation.ViewContext;
import aurora.presentation.ViewCreationException;
import aurora.presentation.component.std.IDGenerator;
import aurora.service.IService;
import aurora.service.ServiceContext;
import aurora.service.ServiceInstance;
import java.io.IOException;
import java.util.List;
import uncertain.composite.CompositeMap;
import uncertain.composite.CompositeUtil;

public class UploadInit
implements IViewBuilder,
E_PrepareServiceConfig {
    private static final String DEFAULT_ATM_BM = "fnd.fnd_atm_attachment";
    IModelFactory mFactory;

    public UploadInit(IModelFactory factory) {
        this.mFactory = factory;
    }

    @Override
    public int onPrepareServiceConfig(IService service) throws Exception {
        ServiceContext sc = service.getServiceContext();
        CompositeMap model = sc.getModel();
        ServiceInstance svc = (ServiceInstance)service;
        CompositeMap screen_config_map = svc.getServiceConfigData();
        if (!"screen".equals(screen_config_map.getName())) {
            return 0;
        }
        ScreenConfig screen = ScreenConfig.createScreenConfig(screen_config_map);
        List list = CompositeUtil.findChilds(screen.getObjectContext(), "upload");
        if (list != null) {
            for (CompositeMap view : list) {
                String pk;
                String id = view.getString("id");
                if (id == null) {
                    id = "up_" + IDGenerator.getInstance().generate();
                    view.put("id", id);
                }
                ModelQueryConfig mqc = ActionConfigManager.createModelQuery();
                mqc.setModel(DEFAULT_ATM_BM);
                mqc.setRootPath("/model/" + id);
                mqc.setAutoCount(false);
                mqc.setFetchAll(true);
                String st = view.getString("sourcetype", "");
                if (st.indexOf("${") == -1) {
                    st = "'" + st + "'";
                }
                if ((pk = view.getString("pkvalue", "-1")).indexOf("${") == -1) {
                    pk = "'" + pk + "'";
                }
                mqc.putString("defaultwhereclause", "fam.table_name = " + st + " and fam.table_pk_value = " + pk + " order by fam.creation_date desc");
                screen.addInitProcedureAction(mqc.getObjectContext());
                CompositeMap ds = new CompositeMap("dataSet");
                ds.setNameSpaceURI("http://www.aurora-framework.org/application");
                ds.putString("model", DEFAULT_ATM_BM);
                ds.put("id", id + "_ds");
                CompositeMap datas = ds.getChild("datas");
                if (datas == null) {
                    datas = ds.createChild("datas");
                }
                datas.putString("datasource", "/model/" + id);
                String context_path = model.getObject("/request/@context_path").toString();
                ds.putString("submiturl", view.getString("deleteurl", context_path + "/atm_delete.svc"));
                screen.addDataSet(ds);
            }
        }
        return 0;
    }

    @Override
    public void buildView(BuildSession session, ViewContext view_context) throws IOException, ViewCreationException {
        try {
            session.buildViews(view_context.getModel(), view_context.getView().getChilds());
        }
        catch (Exception e) {
            throw new ViewCreationException(e);
        }
    }

    @Override
    public String[] getBuildSteps(ViewContext context) {
        return null;
    }
}

