/*
 * Decompiled with CFR 0.152.
 */
package aurora.application.features.cache;

import aurora.application.features.cache.CacheProviderRegistry;
import aurora.application.features.cache.EntityReloadHandler;
import aurora.application.features.cache.ICacheProvider;
import aurora.application.features.cache.IEventHandler;
import aurora.application.features.msg.IConsumer;
import aurora.application.features.msg.IMessage;
import aurora.application.features.msg.IMessageListener;
import aurora.application.features.msg.IMessageStub;
import aurora.application.features.msg.INoticerConsumer;
import aurora.bm.BusinessModel;
import aurora.bm.ICachedDataProvider;
import aurora.bm.IModelFactory;
import aurora.database.FetchDescriptor;
import aurora.database.IResultSetConsumer;
import aurora.database.rsconsumer.CacheWriter;
import aurora.database.service.BusinessModelService;
import aurora.database.service.IDatabaseServiceFactory;
import aurora.database.service.SqlServiceContext;
import aurora.service.IServiceFactory;
import aurora.service.ServiceInvoker;
import java.io.IOException;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import uncertain.cache.ICache;
import uncertain.cache.INamedCacheFactory;
import uncertain.cache.ITransactionCache;
import uncertain.cache.TransactionCache;
import uncertain.composite.CompositeMap;
import uncertain.composite.TextParser;
import uncertain.composite.transform.GroupTransformer;
import uncertain.core.ILifeCycle;
import uncertain.exception.BuiltinExceptionFactory;
import uncertain.exception.GeneralException;
import uncertain.logging.ILogger;
import uncertain.logging.LoggingContext;
import uncertain.ocm.AbstractLocatableObject;
import uncertain.ocm.IObjectRegistry;
import uncertain.proc.IProcedureManager;
import uncertain.proc.Procedure;

public class CacheProvider
extends AbstractLocatableObject
implements ICacheProvider,
IMessageListener,
ILifeCycle {
    protected String cacheName;
    protected String loadProc;
    protected String refreshProc;
    protected String baseBM;
    protected String loadBM;
    protected String refreshBM;
    protected boolean loadOnStartup = true;
    protected IEventHandler[] eventHandlers;
    protected String value = "${@value}";
    protected String type = "value";
    protected String key;
    protected boolean isConcurrent = true;
    protected String groupByFields;
    protected String cacheDesc;
    protected String reloadTopic = "dml_event";
    protected String reloadMessage;
    protected Date lastReloadDate;
    protected boolean inited = false;
    protected ILogger logger;
    protected IProcedureManager procedureManager;
    protected IObjectRegistry mRegistry;
    protected IServiceFactory serviceFactory;
    protected IDatabaseServiceFactory dsFactory;
    protected ICache cache;
    protected INamedCacheFactory mCacheFactory;
    protected IMessageStub messageStub;
    protected boolean shutdown = false;
    protected Timer reloadTimer;
    protected Object reloadLock = new Object();
    private ICachedDataProvider mCacheDataProvider;
    private IModelFactory mModelFactory;
    private Boolean enableResultSetConsumer = null;

    public CacheProvider(IObjectRegistry registry, INamedCacheFactory cacheFactory, ICachedDataProvider cacheDataProvider, IModelFactory modelFactory) {
        this.mRegistry = registry;
        this.mCacheFactory = cacheFactory;
        this.mCacheDataProvider = cacheDataProvider;
        this.mModelFactory = modelFactory;
    }

    @Override
    public void initialize() {
        if (this.cacheName == null) {
            throw BuiltinExceptionFactory.createAttributeMissing(this, "cacheName");
        }
        if (this.key == null) {
            throw BuiltinExceptionFactory.createAttributeMissing(this, "key");
        }
        this.logger = LoggingContext.getLogger(this.getClass().getCanonicalName(), this.mRegistry);
        this.procedureManager = (IProcedureManager)this.mRegistry.getInstanceOfType(IProcedureManager.class);
        if (this.procedureManager == null) {
            throw BuiltinExceptionFactory.createInstanceNotFoundException(this, IProcedureManager.class, this.getClass().getName());
        }
        this.serviceFactory = (IServiceFactory)this.mRegistry.getInstanceOfType(IServiceFactory.class);
        if (this.serviceFactory == null) {
            throw BuiltinExceptionFactory.createInstanceNotFoundException(this, IServiceFactory.class, this.getClass().getName());
        }
        this.dsFactory = (IDatabaseServiceFactory)this.mRegistry.getInstanceOfType(IDatabaseServiceFactory.class);
        if (this.dsFactory == null) {
            throw BuiltinExceptionFactory.createInstanceNotFoundException(this, IDatabaseServiceFactory.class, this.getClass().getName());
        }
        if (this.reloadMessage == null) {
            this.reloadMessage = this.cacheName + "_reload";
        }
        IMessageStub stub = (IMessageStub)this.mRegistry.getInstanceOfType(IMessageStub.class);
        if (this.eventHandlers != null && stub == null) {
            throw BuiltinExceptionFactory.createInstanceNotFoundException(this, IMessageStub.class, this.getClass().getName());
        }
        if (stub != null) {
            IConsumer consumer;
            if (!stub.isStarted()) {
                this.logger.warning("JMS MessageStub is not started, please check the configuration.");
            }
            if ((consumer = stub.getConsumer(this.reloadTopic)) == null) {
                throw new IllegalStateException("MessageStub does not define the reloadTopic '" + this.reloadTopic + "', please check the configuration.");
            }
            if (!(consumer instanceof INoticerConsumer)) {
                throw BuiltinExceptionFactory.createInstanceTypeWrongException(this.getOriginSource(), INoticerConsumer.class, IConsumer.class);
            }
            ((INoticerConsumer)consumer).addListener(this.reloadMessage, this);
        }
        if (this.eventHandlers != null) {
            for (int i = 0; i < this.eventHandlers.length; ++i) {
                this.eventHandlers[i].init(this, this.mRegistry);
            }
        }
        this.initResourcePath();
        if (this.loadOnStartup) {
            this.initCacheDataWithTrx();
        }
        this.initReloadTimer();
        this.inited = true;
        CacheProviderRegistry.put(this.cacheName, this);
    }

    protected void initReloadTimer() {
        this.reloadTimer = new Timer(this.getCacheName() + "_reload_timer");
        TimerTask timerTask = new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (!CacheProvider.this.shutdown) {
                    Object object = CacheProvider.this.reloadLock;
                    synchronized (object) {
                        try {
                            CacheProvider.this.reloadLock.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        if (!CacheProvider.this.shutdown) {
                            CacheProvider.this.reloadWithTrx();
                        }
                    }
                }
            }
        };
        this.reloadTimer.schedule(timerTask, 0L);
    }

    private void initResourcePath() {
        if (this.refreshBM != null && this.loadBM == null && this.loadProc == null) {
            this.loadBM = this.refreshBM;
        }
        if (this.loadBM != null && this.refreshBM == null && this.refreshProc == null) {
            this.refreshBM = this.loadBM;
        }
        if (this.refreshProc != null && this.loadProc == null && this.loadBM == null) {
            this.loadProc = this.refreshProc;
        }
        if (this.loadProc != null && this.refreshBM == null && this.refreshProc == null) {
            this.refreshProc = this.loadProc;
        }
        if (this.baseBM != null) {
            if (this.loadBM == null) {
                this.loadBM = this.baseBM;
            }
            if (this.refreshBM == null) {
                this.refreshBM = this.baseBM;
            }
        }
        if (this.refreshBM != null && this.refreshProc != null) {
            throw BuiltinExceptionFactory.createConflictAttributesExcepiton(this, "refreshBM,refreshProc");
        }
        if (this.loadProc != null && this.loadBM != null) {
            throw BuiltinExceptionFactory.createConflictAttributesExcepiton(this, "loadProc,loadBM");
        }
        if (this.loadProc == null && this.loadBM == null) {
            throw BuiltinExceptionFactory.createOneAttributeMissing(this, "loadProc,loadBM");
        }
    }

    protected void initCacheData() throws Exception {
        if (this.isLoadByBM()) {
            this.executeBM(new CompositeMap());
        } else {
            this.executeProc(this.loadProc, null);
        }
    }

    private void initCacheDataWithTrx() {
        this.beginCacheTransaction();
        try {
            this.initCacheData();
            this.commitCache();
        }
        catch (Exception ex) {
            this.rollbackCache();
            throw new RuntimeException(ex);
        }
    }

    protected void executeBM(CompositeMap context) throws Exception {
        block18: {
            List childs;
            String type;
            CompositeMap data;
            block20: {
                block19: {
                    block17: {
                        if (this.loadBM == null) {
                            return;
                        }
                        IResultSetConsumer resutlSetConsumer = this.getResultSetConsumer();
                        if (resutlSetConsumer != null) {
                            this.queryBMWithConsumer(this.loadBM, resutlSetConsumer, context);
                            return;
                        }
                        data = this.queryBM(this.loadBM, context);
                        if (data == null) {
                            return;
                        }
                        if (this.groupByFields != null) {
                            CompositeMap config = new CompositeMap();
                            CompositeMap level1 = new CompositeMap();
                            level1.put("group_key_fields", this.groupByFields);
                            level1.put("record_name", "level1");
                            config.addChild(level1);
                            data = GroupTransformer.transformByConfig((CompositeMap)data.clone(), config);
                        }
                        type = this.getType();
                        childs = data.getChilds();
                        if (!ICacheProvider.VALUE_TYPE.value.name().equals(type)) break block17;
                        if (childs == null) {
                            String key = TextParser.parse(this.getKey(), data);
                            String value = TextParser.parse(this.getValue(), data);
                            this.cache.setValue(key, value);
                        } else {
                            for (Object child : data.getChilds()) {
                                CompositeMap record = (CompositeMap)child;
                                String key = TextParser.parse(this.getKey(), record);
                                String value = TextParser.parse(this.getValue(), record);
                                this.cache.setValue(key, value);
                            }
                        }
                        break block18;
                    }
                    if (!ICacheProvider.VALUE_TYPE.record.name().equals(type)) break block19;
                    if (childs == null) {
                        String key = TextParser.parse(this.getKey(), data);
                        this.cache.setValue(key, data);
                    } else {
                        for (Object child : data.getChilds()) {
                            CompositeMap record = (CompositeMap)child;
                            String key = TextParser.parse(this.getKey(), record);
                            this.cache.setValue(key, record);
                        }
                    }
                    break block18;
                }
                if (!ICacheProvider.VALUE_TYPE.valueSet.name().equals(type)) break block20;
                if (childs == null) {
                    return;
                }
                for (Object child : data.getChilds()) {
                    CompositeMap record = (CompositeMap)child;
                    String key = TextParser.parse(this.getKey(), record);
                    List new_values = record.getChilds();
                    if (new_values == null) {
                        throw new IllegalArgumentException("Value type is 'valueSet', please group by the data first!");
                    }
                    LinkedList<String> value_list = new LinkedList<String>();
                    this.cache.setValue(key, value_list);
                    for (Object value : new_values) {
                        CompositeMap newValue_record = (CompositeMap)value;
                        String new_value = TextParser.parse(this.getValue(), newValue_record);
                        value_list.add(new_value);
                    }
                }
                break block18;
            }
            if (!ICacheProvider.VALUE_TYPE.recordSet.name().equals(type)) break block18;
            if (childs == null) {
                return;
            }
            for (Object child : data.getChilds()) {
                CompositeMap record = (CompositeMap)child;
                String key = TextParser.parse(this.getKey(), record);
                List new_values = record.getChilds();
                if (new_values == null) {
                    throw new IllegalArgumentException("Value type is 'recordSet', please group by the data first!");
                }
                LinkedList value_list = new LinkedList();
                this.cache.setValue(key, value_list);
                value_list.addAll(new_values);
            }
        }
    }

    private IResultSetConsumer getResultSetConsumer() {
        if (!this.enableResultSetConsumer.booleanValue()) {
            return null;
        }
        if (this.groupByFields != null) {
            throw BuiltinExceptionFactory.createConflictAttributesExcepiton(this, "enableResultSetConsumer,groupByFields");
        }
        CacheWriter cw = new CacheWriter(this.mCacheFactory);
        cw.setCacheName(this.cacheName);
        cw.setRecordKey(this.key);
        return cw;
    }

    protected void executeProc(String procedure, CompositeMap context) throws Exception {
        this.logger.log(Level.CONFIG, "load procedure:{0}", new Object[]{procedure});
        Procedure proc = null;
        try {
            proc = this.procedureManager.loadProcedure(procedure);
        }
        catch (Exception ex) {
            throw BuiltinExceptionFactory.createResourceLoadException(this, procedure, ex);
        }
        String name = "Cache." + procedure;
        if (context != null) {
            ServiceInvoker.invokeProcedureWithTransaction(name, proc, this.serviceFactory, context);
        } else {
            ServiceInvoker.invokeProcedureWithTransaction(name, proc, this.serviceFactory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompositeMap queryBM(String bm_name, CompositeMap queryMap) throws Exception {
        SqlServiceContext sqlContext = this.dsFactory.createContextWithConnection();
        try {
            CompositeMap resultMap;
            CompositeMap context = sqlContext.getObjectContext();
            if (context == null) {
                context = new CompositeMap();
            }
            BusinessModelService service = this.dsFactory.getModelService(bm_name, context);
            CompositeMap compositeMap = resultMap = service.queryAsMap(queryMap, FetchDescriptor.fetchAll());
            return compositeMap;
        }
        finally {
            if (sqlContext != null) {
                sqlContext.freeConnection();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queryBMWithConsumer(String bm_name, IResultSetConsumer consumer, CompositeMap queryMap) throws Exception {
        SqlServiceContext sqlContext = this.dsFactory.createContextWithConnection();
        try {
            CompositeMap context = sqlContext.getObjectContext();
            if (context == null) {
                context = new CompositeMap();
            }
            BusinessModelService service = this.dsFactory.getModelService(bm_name, context);
            service.query(queryMap, consumer, FetchDescriptor.fetchAll());
        }
        finally {
            if (sqlContext != null) {
                sqlContext.freeConnection();
            }
        }
    }

    public CompositeMap queryBM(CompositeMap queryMap) throws Exception {
        return this.queryBM(this.getRefreshBM(), queryMap);
    }

    public void setName(String name) {
        this.cacheName = name;
    }

    public void reloadWithTrx() {
        this.beginCacheTransaction();
        try {
            this.reload();
            this.commitCache();
        }
        catch (Exception e) {
            this.rollbackCache();
            this.logger.log(Level.SEVERE, "", e);
        }
    }

    @Override
    public void reload() {
        try {
            this.cache.clear();
            this.initCacheData();
            this.setLastReloadDate(new Date());
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "", e);
        }
    }

    public Object getValue(CompositeMap parameter) {
        if (!this.inited) {
            try {
                this.initCacheDataWithTrx();
            }
            catch (Exception e) {
                throw new RuntimeException("init cache:" + this.getCacheName() + " failed!");
            }
        }
        String keyValue = TextParser.parse(this.key, parameter);
        return this.cache.getValue(keyValue);
    }

    public String getRefreshBM() {
        return this.refreshBM;
    }

    public void setRefreshBM(String refreshBM) {
        this.refreshBM = refreshBM;
    }

    public String getCacheKey() {
        return this.key;
    }

    public void setCacheKey(String key) {
        this.key = key;
    }

    public boolean getLoadOnStart() {
        return this.loadOnStartup;
    }

    public void setLoadOnStart(boolean loadOnStart) {
        this.loadOnStartup = loadOnStart;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public IEventHandler[] getEventHandlers() {
        return this.eventHandlers;
    }

    public void setEventHandlers(IEventHandler[] eventHandlers) {
        this.eventHandlers = eventHandlers;
    }

    public String getLoadProc() {
        return this.loadProc;
    }

    public void setLoadProc(String loadProc) {
        this.loadProc = loadProc;
    }

    public String getRefreshProc() {
        return this.refreshProc;
    }

    public void setRefreshProc(String refreshProc) {
        this.refreshProc = refreshProc;
    }

    public String getBaseBM() {
        return this.baseBM;
    }

    public void setBaseBM(String baseBM) {
        this.baseBM = baseBM;
    }

    public String getLoadBM() {
        return this.loadBM;
    }

    public void setLoadBM(String loadBM) {
        this.loadBM = loadBM;
    }

    protected boolean isLoadByBM() {
        return this.loadBM != null;
    }

    protected boolean isRefreshByBM() {
        return this.refreshBM != null;
    }

    public boolean isConcurrent() {
        return this.isConcurrent;
    }

    public void setConcurrent(boolean isConcurrent) {
        this.isConcurrent = isConcurrent;
    }

    public boolean getConcurrent() {
        return this.isConcurrent;
    }

    @Override
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Override
    public String getCacheName() {
        return this.cacheName;
    }

    public void setCacheName(String cacheName) {
        this.cacheName = cacheName;
    }

    public void removeKey(String key) {
        this.cache.remove(key);
    }

    @Override
    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    @Override
    public ICache getCache() {
        return this.cache;
    }

    public String getGroupByFields() {
        return this.groupByFields;
    }

    public void setGroupByFields(String groupByFields) {
        this.groupByFields = groupByFields;
    }

    @Override
    public String getCacheDesc() {
        return this.cacheDesc;
    }

    public void setCacheDesc(String cacheDesc) {
        this.cacheDesc = cacheDesc;
    }

    @Override
    public String getReloadTopic() {
        return this.reloadTopic;
    }

    public void setReloadTopic(String reloadTopic) {
        this.reloadTopic = reloadTopic;
    }

    @Override
    public String getReloadMessage() {
        return this.reloadMessage;
    }

    public void setReloadMessage(String reloadMessage) {
        this.reloadMessage = reloadMessage;
    }

    @Override
    public Date getLastReloadDate() {
        return this.lastReloadDate;
    }

    public void setLastReloadDate(Date date) {
        this.lastReloadDate = date;
    }

    public boolean getEnableResultSetConsumer() {
        return this.enableResultSetConsumer;
    }

    public void setEnableResultSetConsumer(boolean enableResultSetConsumer) {
        this.enableResultSetConsumer = enableResultSetConsumer;
    }

    public void beginCacheTransaction() {
        if (this.isITransactionCache(this.cache)) {
            ((ITransactionCache)this.cache).beginTransaction();
        }
    }

    public void commitCache() {
        if (this.isITransactionCache(this.cache)) {
            ((ITransactionCache)this.cache).commit();
        }
    }

    public void rollbackCache() {
        if (this.isITransactionCache(this.cache)) {
            ((ITransactionCache)this.cache).rollback();
        }
    }

    private boolean isITransactionCache(ICache cache) {
        return cache != null && cache instanceof ITransactionCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onMessage(IMessage message) {
        block5: {
            try {
                if (!this.reloadMessage.equals(message.getText())) break block5;
                Object object = this.reloadLock;
                synchronized (object) {
                    this.reloadLock.notify();
                }
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "reload failed!", e);
            }
        }
    }

    @Override
    public boolean startup() {
        if (this.baseBM != null) {
            this.setDefaultConfigForBaseBM();
        }
        if (this.enableResultSetConsumer == null) {
            this.enableResultSetConsumer = false;
        }
        if (this.key == null) {
            this.key = "${@key}";
        }
        this.cache = this.mCacheFactory.getNamedCache(this.cacheName);
        if (this.cache == null) {
            throw new GeneralException("uncertain.cache.named_cache_not_found", new Object[]{this.cache}, this);
        }
        if (this.isConcurrent) {
            this.cache = new TransactionCache(this.cache);
            this.mCacheFactory.setNamedCache(this.cacheName, this.cache);
        }
        return true;
    }

    private void setDefaultConfigForBaseBM() {
        BusinessModel model;
        try {
            model = this.mModelFactory.getModel(this.baseBM);
        }
        catch (IOException e) {
            throw BuiltinExceptionFactory.createResourceLoadException(this, this.baseBM, e);
        }
        if (this.key == null) {
            this.key = this.mCacheDataProvider.getCacheKey(model);
        } else if (!this.key.contains(this.baseBM)) {
            this.key = this.baseBM + "." + this.key;
        }
        if (this.cacheName == null) {
            this.cacheName = this.mCacheDataProvider.getCacheName(model);
        }
        if (this.cacheDesc == null) {
            this.cacheDesc = this.cacheName;
        }
        this.setType(ICacheProvider.VALUE_TYPE.record.name());
        if (this.enableResultSetConsumer == null) {
            this.enableResultSetConsumer = true;
        }
        if (this.eventHandlers == null) {
            EntityReloadHandler entityReloadHandler = new EntityReloadHandler();
            entityReloadHandler.setEntity(model.getBaseTable());
            entityReloadHandler.setReloadBM(this.baseBM);
            entityReloadHandler.setTopic(this.getReloadTopic());
            this.setEventHandlers(new IEventHandler[]{entityReloadHandler});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        this.shutdown = true;
        CacheProviderRegistry.remove(this.cacheName);
        Object object = this.reloadLock;
        synchronized (object) {
            this.reloadLock.notify();
        }
        if (this.reloadTimer != null) {
            this.reloadTimer.cancel();
        }
    }
}

