/*
 * Decompiled with CFR 0.152.
 */
package aurora.database.sql;

import aurora.database.sql.AbstractStatement;
import aurora.database.sql.ConditionList;
import aurora.database.sql.ILogicalExpression;
import aurora.database.sql.OracleJoinExpression;
import aurora.database.sql.SelectField;
import aurora.database.sql.SelectSource;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class Join
extends AbstractStatement {
    public static final String TYPE_INNER_JOIN = "INNER JOIN";
    public static final String TYPE_LEFT_OUTTER_JOIN = "LEFT OUTER JOIN";
    public static final String TYPE_RIGHT_OUTTER_JOIN = "RIGHT OUTER JOIN";
    public static final String TYPE_FULL_OUTTER_JOIN = "FULL OUTER JOIN";
    public static final String TYPE_CROSS_JOIN = "CROSS JOIN";
    public static final String NATURAL = "NATURAL";
    static Set ALL_TYPES = new HashSet();
    String type;
    boolean isNatural = false;
    SelectSource leftPart;
    SelectSource rightPart;
    ConditionList joinConditions;
    int joinOrder = 0;

    public static boolean isTypeValid(String type) {
        if (type == null) {
            return false;
        }
        return ALL_TYPES.contains(type.toUpperCase());
    }

    public Join(String type, SelectSource left, SelectSource right) {
        super(type);
        if (left == null || right == null) {
            throw new IllegalArgumentException("Must provide both left part and right part for a join");
        }
        if (!Join.isTypeValid(type)) {
            throw new IllegalArgumentException("invalid join type:" + type);
        }
        this.joinConditions = new ConditionList();
        this.joinConditions.setParent(this);
        this.setLeftPart(left);
        this.setRightPart(right);
    }

    public boolean isNatural() {
        return this.isNatural;
    }

    public void setNatural(boolean isNatural) {
        if (TYPE_CROSS_JOIN.equals(this.type) && isNatural) {
            throw new IllegalArgumentException("Can't set a cross join to natural");
        }
        this.isNatural = isNatural;
    }

    public SelectSource getLeftPart() {
        return this.leftPart;
    }

    public void setLeftPart(SelectSource leftPart) {
        this.leftPart = leftPart;
    }

    public SelectSource getRightPart() {
        return this.rightPart;
    }

    public void setRightPart(SelectSource rightPart) {
        this.rightPart = rightPart;
    }

    public ConditionList getJoinConditions() {
        return this.joinConditions;
    }

    public void addJoinCondition(ILogicalExpression condition) {
        this.joinConditions.addCondition(condition);
    }

    public void addJoinConditions(ILogicalExpression[] condition) {
        this.joinConditions.addConditions(condition);
    }

    public void addJoinConditions(Collection condition_list) {
        this.joinConditions.addConditions(condition_list);
    }

    public void addJoinField(SelectField left_field, SelectField right_field) {
        OracleJoinExpression cexp = new OracleJoinExpression(this.getType(), left_field, 1, right_field);
        this.addJoinCondition(cexp);
    }

    public int getOrder() {
        return this.joinOrder;
    }

    public void setOrder(int joinOrder) {
        this.joinOrder = joinOrder;
    }

    static {
        ALL_TYPES.add(TYPE_INNER_JOIN);
        ALL_TYPES.add(TYPE_LEFT_OUTTER_JOIN);
        ALL_TYPES.add(TYPE_RIGHT_OUTTER_JOIN);
        ALL_TYPES.add(TYPE_FULL_OUTTER_JOIN);
        ALL_TYPES.add(TYPE_CROSS_JOIN);
    }
}

