/*
 * Decompiled with CFR 0.152.
 */
package aurora.presentation.component.std;

import aurora.presentation.BuildSession;
import aurora.presentation.component.std.Box;
import java.io.Writer;
import java.util.Map;
import uncertain.composite.CompositeMap;
import uncertain.composite.TextParser;

public class FieldSet
extends Box {
    public static final String VERSION = "$Revision: 6975 $";
    protected static final String PROPERTITY_TITLE = "title";
    private static final String DEFAULT_BODY_CLASS = "form_body";

    @Override
    protected void buildHead(BuildSession session, CompositeMap model, CompositeMap view, int rows, int columns) throws Exception {
        Writer out = session.getWriter();
        String title = view.getString(PROPERTITY_TITLE, "");
        title = session.getLocalizedPrompt(title);
        out.write("<LEGEND class='field_head' unselectable='on'><SPAN>");
        out.write(title);
        out.write("</SPAN></LEGEND>");
    }

    @Override
    protected void afterBuildTop(BuildSession session, CompositeMap model, CompositeMap view, int columns) throws Exception {
        Writer out = session.getWriter();
        out.write("<tbody class='form_body'>");
        super.afterBuildTop(session, model, view, columns);
    }

    @Override
    protected void buildTop(BuildSession session, CompositeMap model, CompositeMap view, Map map, int rows, int columns, String id) throws Exception {
        Writer out = session.getWriter();
        String cls = view.getString("classname", "");
        String style = view.getString("style", "");
        String widthStr = view.getString("width", "0");
        String wstr = TextParser.parse(widthStr, model);
        int width = Integer.valueOf(wstr);
        String heightStr = view.getString("height", "0");
        String hstr = TextParser.parse(heightStr, model);
        int height = Integer.valueOf(hstr);
        int cellspacing = view.getInt("cellspacing", 0);
        int cellpadding = view.getInt("cellpadding", 0);
        String className = "layout-table";
        String title = view.getString(PROPERTITY_TITLE, "");
        if (!"".equals(title)) {
            className = className + " layout-title";
        }
        className = className + " " + cls;
        out.write("<FIELDSET class='item-fieldset' id='" + id + "'");
        StringBuffer sb = new StringBuffer();
        if (!"".equals(style)) {
            sb.append(style);
        }
        if (width != 0) {
            sb.append("width:" + (width - 2) + "px;");
        }
        if (height != 0) {
            sb.append("height:" + height + "px;");
        }
        if (sb.length() != 0) {
            out.write(" style='" + sb.toString() + "'");
        }
        out.write(">");
        this.buildHead(session, model, view, rows, columns);
        out.write("<table width='100%' border=0");
        out.write(" cellpadding=" + cellpadding + " cellspacing=" + cellspacing + ">");
        this.afterBuildTop(session, model, view, columns);
    }

    @Override
    protected void buildBottom(BuildSession session, CompositeMap model, CompositeMap view, int columns) throws Exception {
        this.buildFoot(session, model, view, columns);
        Writer out = session.getWriter();
        String showmargin = view.getString("showmargin", "true");
        if ("true".equals(showmargin)) {
            out.write("<tr height='5'><td colspan=" + columns * 2 + "></td></tr>");
        }
        out.write("</tbody>");
        out.write("</table>");
        out.write("</FIELDSET>");
    }
}

