/*
 * Decompiled with CFR 0.152.
 */
package aurora.presentation.component.std;

import aurora.presentation.BuildSession;
import aurora.presentation.component.std.Box;
import java.io.Writer;
import java.util.Map;
import uncertain.composite.CompositeMap;

public class Form
extends Box {
    public static final String VERSION = "$Revision: 6975 $";
    private static final String DEFAULT_HEAD_CLASS = "form_head";
    private static final String DEFAULT_BODY_CLASS = "form_body";

    @Override
    protected void buildHead(BuildSession session, CompositeMap model, CompositeMap view, int rows, int columns) throws Exception {
        String theme = session.getTheme();
        if ("mac".equals(theme)) {
            return;
        }
        Writer out = session.getWriter();
        String title = view.getString("title", "");
        if (!"".equals(title = session.getLocalizedPrompt(title))) {
            out.write("<thead><tr><th class='form_head' colspan=" + columns * 2 + ">");
            out.write(title);
            out.write("</th></tr></thead>");
        }
    }

    @Override
    protected void afterBuildTop(BuildSession session, CompositeMap model, CompositeMap view, int columns) throws Exception {
        Writer out = session.getWriter();
        out.write("<tbody class='form_body'>");
        String showmargin = view.getString("showmargin", "true");
        boolean showBorder = view.getBoolean("showborder", false);
        if ("true".equals(showmargin) && !showBorder) {
            out.write("<tr height='5'><td colspan=" + columns * 2 + "></td></tr>");
        }
        super.afterBuildTop(session, model, view, columns);
    }

    @Override
    protected String getClassName(BuildSession session, CompositeMap model, CompositeMap view) throws Exception {
        String cls = view.getString("classname", "");
        boolean showBorder = view.getBoolean("showborder", false);
        String className = "layout-table layout-form";
        String title = view.getString("title", "");
        if (!"".equals(title)) {
            className = className + " layout-title";
        }
        className = className + " " + cls;
        if (showBorder) {
            className = className + " layout-border";
        }
        return className;
    }

    @Override
    protected String getStyle(BuildSession session, CompositeMap model, CompositeMap view) throws Exception {
        String style = view.getString("style", "");
        boolean showBorder = view.getBoolean("showborder", false);
        if (showBorder) {
            style = style + " border:none;";
        }
        return style;
    }

    @Override
    protected void beforeBuildTop(BuildSession session, CompositeMap model, CompositeMap view, String id) throws Exception {
        String theme = session.getTheme();
        if ("mac".equals(theme)) {
            String style = this.getStyle(session, model, view);
            Writer out = session.getWriter();
            String title = view.getString("title", "");
            if (!"".equals(title = session.getLocalizedPrompt(title))) {
                out.write("<table border='0' class='mac_form' cellpadding='0' cellSpacing='0' id='" + id + "'");
                if (!"".equals(style)) {
                    out.write(" style='" + style + "'");
                }
                out.write("><tr><td class='form_head'>");
                out.write(title);
                out.write("</td></tr><tr><td>");
            }
        }
    }

    @Override
    protected void buildTop(BuildSession session, CompositeMap model, CompositeMap view, Map map, int rows, int columns, String id) throws Exception {
        String theme;
        this.beforeBuildTop(session, model, view, id);
        Writer out = session.getWriter();
        int cellspacing = view.getInt("cellspacing", 0);
        int cellpadding = view.getInt("cellpadding", 0);
        boolean showBorder = view.getBoolean("showborder", false);
        String title = view.getString("title", "");
        title = session.getLocalizedPrompt(title);
        int width = this.getComponentWidth(model, view, map);
        int height = this.getComponentHeight(model, view, map);
        String className = this.getClassName(session, model, view);
        String style = this.getStyle(session, model, view);
        if (showBorder) {
            cellspacing = 1;
            className = className + " layout-border";
        }
        if ("mac".equals(theme = session.getTheme())) {
            out.write("<table border=0 class='" + className + "'");
        } else {
            out.write("<table border=0 class='" + className + "' id='" + id + "'");
        }
        if (width != 0) {
            out.write(" width=" + width);
        }
        if (height != 0) {
            out.write(" height=" + height);
        }
        if ("mac".equals(theme) && !"".equals(title)) {
            out.write(" style='width:100%'");
        } else if (!"".equals(style)) {
            out.write(" style='" + style + "'");
        }
        out.write(" cellpadding=" + cellpadding + " cellspacing=" + cellspacing + ">");
        this.buildHead(session, model, view, rows, columns);
        this.afterBuildTop(session, model, view, columns);
    }

    @Override
    protected void buildFoot(BuildSession session, CompositeMap model, CompositeMap view, int columns) throws Exception {
        super.buildFoot(session, model, view, columns);
        Writer out = session.getWriter();
        String showmargin = view.getString("showmargin", "true");
        boolean showBorder = view.getBoolean("showborder", false);
        if ("true".equals(showmargin) && !showBorder) {
            out.write("<tr height='5'><td colspan=" + columns * 2 + "></td></tr>");
        }
    }

    @Override
    protected void afterBuildBottom(BuildSession session, CompositeMap model, CompositeMap view, int columns) throws Exception {
        String theme = session.getTheme();
        String title = view.getString("title", "");
        title = session.getLocalizedPrompt(title);
        if ("mac".equals(theme) && !"".equals(title)) {
            Writer out = session.getWriter();
            out.write("</td></tr></table>");
        }
    }
}

