/*
 * Decompiled with CFR 0.152.
 */
package aurora.presentation.component.std.config;

import aurora.presentation.component.std.config.ComponentConfig;
import aurora.presentation.component.std.config.GridConfig;
import uncertain.composite.CompositeMap;

public class RadioConfig
extends ComponentConfig {
    public static final String VERSION = "$Revision: 6976 $";
    public static final String TAG_NAME = "radio";
    private static final String RROPERTITY_ITEMS = "items";
    private static final String PROPERTITY_LABEL_FIELD = "labelfield";
    private static final String PROPERTITY_VALUE_FIELD = "valuefield";
    private static final String PROPERTITY_LAYOUT = "layout";
    private static final String PROPERTITY_OPTIONS = "options";
    private static final String PROPERTITY_LABEL_EXPRESSION = "labelexpression";
    public static final String PROPERTITY_RADIO_SEPARATOR = "radioseparator";
    public static final String DEFAULT_LAYOUT_HORIZONTAL = "horizontal";
    public static final String DEFAULT_LAYOUT_VERTICAL = "vertical";
    public static final String DEFAULT_LABEL_FIELD = "label";
    public static final String DEFAULT_VALUE_FIELD = "value";

    public static RadioConfig getInstance() {
        RadioConfig model = new RadioConfig();
        model.initialize(GridConfig.createContext(null, TAG_NAME));
        return model;
    }

    public static RadioConfig getInstance(CompositeMap context) {
        RadioConfig model = new RadioConfig();
        model.initialize(GridConfig.createContext(context, TAG_NAME));
        return model;
    }

    public String getLayout() {
        return this.getString(PROPERTITY_LAYOUT, DEFAULT_LAYOUT_HORIZONTAL);
    }

    public void setLayout(String layout) {
        this.putString(PROPERTITY_LAYOUT, layout);
    }

    public String getLabelField() {
        return this.getString(PROPERTITY_LABEL_FIELD, DEFAULT_LABEL_FIELD);
    }

    public void setLabelField(String field) {
        this.putString(PROPERTITY_LABEL_FIELD, field);
    }

    public String getValueField() {
        return this.getString(PROPERTITY_VALUE_FIELD, DEFAULT_VALUE_FIELD);
    }

    public void setValueField(String field) {
        this.putString(PROPERTITY_VALUE_FIELD, field);
    }

    public String getLabelExpression() {
        return this.getString(PROPERTITY_LABEL_EXPRESSION);
    }

    public void setLabelExpression(String expression) {
        this.putString(PROPERTITY_LABEL_EXPRESSION, expression);
    }

    public CompositeMap getItems() {
        CompositeMap context = this.getObjectContext();
        CompositeMap columns = context.getChild(RROPERTITY_ITEMS);
        return columns;
    }

    public String getOptions() {
        return this.getString(PROPERTITY_OPTIONS);
    }

    public void setOptions(String options) {
        this.putString(PROPERTITY_OPTIONS, options);
    }

    public String getRadioSeparator() {
        return this.getString(PROPERTITY_RADIO_SEPARATOR);
    }

    public void setRadioSeparator(String radioseparator) {
        this.putString(PROPERTITY_RADIO_SEPARATOR, radioseparator);
    }
}

