/*
 * Decompiled with CFR 0.152.
 */
package aurora.service.http;

import aurora.service.IConfigurableService;
import aurora.service.IService;
import aurora.service.ServiceContext;
import aurora.service.ServiceController;
import aurora.service.ServiceThreadLocal;
import aurora.service.http.WebContextInit;
import aurora.transaction.ITransactionService;
import aurora.transaction.UserTransactionImpl;
import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.transaction.UserTransaction;
import uncertain.core.UncertainEngine;
import uncertain.event.Configuration;
import uncertain.event.IEventDispatcher;
import uncertain.event.IParticipantManager;
import uncertain.ocm.IObjectRegistry;
import uncertain.proc.IProcedureManager;
import uncertain.proc.IProcedureRegistry;
import uncertain.proc.Procedure;
import uncertain.proc.trace.StackTraceManager;
import uncertain.proc.trace.TraceElement;

public abstract class AbstractFacadeServlet
extends HttpServlet {
    public static final String PRE_SERVICE = "pre-service";
    UncertainEngine mUncertainEngine;
    IProcedureManager mProcManager;
    ServletConfig mConfig;
    ServletContext mContext;
    IProcedureRegistry mProcRegistry;
    Configuration mGlobalServiceConfig;

    protected abstract IService createServiceInstance(HttpServletRequest var1, HttpServletResponse var2) throws Exception;

    protected abstract void populateService(HttpServletRequest var1, HttpServletResponse var2, IService var3) throws Exception;

    protected abstract void handleException(HttpServletRequest var1, HttpServletResponse var2, Throwable var3) throws IOException, ServletException;

    protected abstract void cleanUp(IService var1);

    protected void writeCacheDirection(HttpServletResponse response, IService service) {
        response.setHeader("Cache-Control", "no-cache");
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Expires", "0");
    }

    public static Procedure getProcedureToRun(IProcedureManager procManager, IService service) throws Exception {
        String procedure_name = null;
        IEventDispatcher config = service.getConfig();
        config.fireEvent("DetectProcedure", new Object[]{service});
        ServiceController controller = ServiceController.createServiceController(service.getServiceContext().getObjectContext());
        if (!controller.getContinueFlag()) {
            return null;
        }
        procedure_name = controller.getProcedureName();
        Procedure proc = procManager.loadProcedure(procedure_name);
        return proc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        boolean is_success;
        IService svc;
        StackTraceManager stm;
        ITransactionService ts;
        UserTransaction trans;
        block43: {
            if (!this.mUncertainEngine.isRunning()) {
                StringBuffer msg = new StringBuffer("Application failed to initialize");
                Throwable thr = this.mUncertainEngine.getInitializeException();
                if (thr != null) {
                    msg.append(":").append(thr.getMessage());
                }
                response.sendError(500, msg.toString());
                return;
            }
            trans = null;
            IObjectRegistry or = this.mUncertainEngine.getObjectRegistry();
            ts = (ITransactionService)or.getInstanceOfType(ITransactionService.class);
            if (ts == null) {
                throw new ServletException("ITransactionService instance not found");
            }
            trans = ts.getUserTransaction();
            stm = new StackTraceManager();
            request.setCharacterEncoding("UTF-8");
            svc = null;
            ServiceContext ctx = null;
            is_success = true;
            try {
                IConfigurableService cfsvc;
                Procedure proc;
                trans.begin();
                svc = this.createServiceInstance(request, response);
                ctx = svc.getServiceContext();
                ctx.setStackTraceManager(stm);
                ServiceThreadLocal.setCurrentThreadContext(ctx.getObjectContext());
                ServiceThreadLocal.setSource(request.getRequestURI());
                this.populateService(request, response, svc);
                this.writeCacheDirection(response, svc);
                Procedure pre_service_proc = null;
                if (this.mProcRegistry != null) {
                    pre_service_proc = this.mProcRegistry.getProcedure(PRE_SERVICE);
                }
                if (pre_service_proc != null) {
                    is_success = svc.invoke(pre_service_proc);
                }
                if (!is_success || (proc = AbstractFacadeServlet.getProcedureToRun(this.mProcManager, svc)) == null) break block43;
                if (svc instanceof IConfigurableService && !(cfsvc = (IConfigurableService)((Object)svc)).isConfigParsed()) {
                    cfsvc.parseConfig();
                }
                is_success = svc.invoke(proc);
                if (!ctx.hasError()) break block43;
                is_success = false;
            }
            catch (Throwable ex) {
                try {
                    is_success = false;
                    this.mUncertainEngine.logException("Error when executing service " + request.getRequestURI(), ex);
                    this.handleException(request, response, ex);
                }
                catch (Throwable throwable) {
                    if (trans instanceof UserTransactionImpl) {
                        ((UserTransactionImpl)trans).setContext(svc.getServiceContext().getObjectContext());
                    }
                    if (is_success) {
                        try {
                            trans.commit();
                        }
                        catch (Throwable e) {
                            this.mUncertainEngine.logException("Error when commit service " + request.getRequestURI(), e);
                        }
                    } else {
                        try {
                            trans.rollback();
                        }
                        catch (Throwable e) {
                            this.mUncertainEngine.logException("Error when rollback service " + request.getRequestURI(), e);
                        }
                    }
                    svc.release();
                    TraceElement elm = stm.getRootNode();
                    if (elm != null) {
                        elm.setExitTime(System.currentTimeMillis());
                    }
                    if (svc != null && svc.getConfig() != null) {
                        try {
                            svc.getConfig().fireEvent("ServiceFinish", new Object[]{svc});
                        }
                        catch (Throwable ex2) {
                            this.mUncertainEngine.logException("Error when fire ServiceFinish", ex2);
                        }
                    }
                    ServiceThreadLocal.remove();
                    this.cleanUp(svc);
                    ts.stop();
                    throw throwable;
                }
                if (trans instanceof UserTransactionImpl) {
                    ((UserTransactionImpl)trans).setContext(svc.getServiceContext().getObjectContext());
                }
                if (is_success) {
                    try {
                        trans.commit();
                    }
                    catch (Throwable e) {
                        this.mUncertainEngine.logException("Error when commit service " + request.getRequestURI(), e);
                    }
                } else {
                    try {
                        trans.rollback();
                    }
                    catch (Throwable e) {
                        this.mUncertainEngine.logException("Error when rollback service " + request.getRequestURI(), e);
                    }
                }
                svc.release();
                TraceElement elm = stm.getRootNode();
                if (elm != null) {
                    elm.setExitTime(System.currentTimeMillis());
                }
                if (svc != null && svc.getConfig() != null) {
                    try {
                        svc.getConfig().fireEvent("ServiceFinish", new Object[]{svc});
                    }
                    catch (Throwable ex3) {
                        this.mUncertainEngine.logException("Error when fire ServiceFinish", ex3);
                    }
                }
                ServiceThreadLocal.remove();
                this.cleanUp(svc);
                ts.stop();
            }
        }
        if (trans instanceof UserTransactionImpl) {
            ((UserTransactionImpl)trans).setContext(svc.getServiceContext().getObjectContext());
        }
        if (is_success) {
            try {
                trans.commit();
            }
            catch (Throwable e) {
                this.mUncertainEngine.logException("Error when commit service " + request.getRequestURI(), e);
            }
        } else {
            try {
                trans.rollback();
            }
            catch (Throwable e) {
                this.mUncertainEngine.logException("Error when rollback service " + request.getRequestURI(), e);
            }
        }
        svc.release();
        TraceElement elm = stm.getRootNode();
        if (elm != null) {
            elm.setExitTime(System.currentTimeMillis());
        }
        if (svc != null && svc.getConfig() != null) {
            try {
                svc.getConfig().fireEvent("ServiceFinish", new Object[]{svc});
            }
            catch (Throwable ex) {
                this.mUncertainEngine.logException("Error when fire ServiceFinish", ex);
            }
        }
        ServiceThreadLocal.remove();
        this.cleanUp(svc);
        ts.stop();
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.mConfig = config;
        this.mContext = config.getServletContext();
        this.mUncertainEngine = WebContextInit.getUncertainEngine(this.mContext);
        if (this.mUncertainEngine == null) {
            throw new ServletException("Uncertain engine not initialized");
        }
        this.mProcManager = this.mUncertainEngine.getProcedureManager();
        this.mProcRegistry = (IProcedureRegistry)this.mUncertainEngine.getObjectRegistry().getInstanceOfType(IProcedureRegistry.class);
        IObjectRegistry reg = this.getObjectRegistry();
        IParticipantManager pm = (IParticipantManager)reg.getInstanceOfType(IParticipantManager.class);
        if (pm != null) {
            this.mGlobalServiceConfig = pm.getParticipantsAsConfig("service");
        }
    }

    public UncertainEngine getUncertainEngine() {
        return this.mUncertainEngine;
    }

    public IObjectRegistry getObjectRegistry() {
        return this.mUncertainEngine == null ? null : this.mUncertainEngine.getObjectRegistry();
    }

    public Configuration getGlobalServiceConfig() {
        return this.mGlobalServiceConfig;
    }
}

