/*
 * Decompiled with CFR 0.152.
 */
package aurora.service.http;

import aurora.application.IApplicationConfig;
import aurora.application.config.ScreenConfig;
import aurora.bm.BusinessModel;
import aurora.database.actions.config.ActionConfigManager;
import aurora.database.actions.config.ModelQueryConfig;
import aurora.service.IService;
import aurora.service.ServiceContext;
import aurora.service.controller.ControllerProcedures;
import aurora.service.http.AbstractAutoServiceServlet;
import aurora.service.http.AutoCrudServiceContext;
import aurora.service.http.HttpServiceInstance;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import uncertain.composite.CompositeMap;

public class AutoCrudServlet
extends AbstractAutoServiceServlet {
    boolean enableBMTrace = false;
    public static final String KEY_UPDATE_PASSED_FIELD_ONLY = "_updatepassedfieldonly";

    @Override
    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        IApplicationConfig appConfig = (IApplicationConfig)this.mUncertainEngine.getObjectRegistry().getInstanceOfType(IApplicationConfig.class);
        if (appConfig != null) {
            this.enableBMTrace = appConfig.getApplicationConfig().getBoolean("enablebmtrace", this.enableBMTrace);
        }
    }

    private void prepareUpdateAction(ServiceContext context, CompositeMap action_config) {
        boolean is_update_passed_fields = true;
        if ("false".equalsIgnoreCase(context.getParameter().getString(KEY_UPDATE_PASSED_FIELD_ONLY))) {
            is_update_passed_fields = false;
        }
        action_config.putBoolean("updatepassedfieldonly", is_update_passed_fields);
    }

    @Override
    protected void populateService(HttpServletRequest request, HttpServletResponse response, IService service) throws Exception {
        HttpServiceInstance svc = (HttpServiceInstance)service;
        svc.getController().setProcedureName(ControllerProcedures.INVOKE_SERVICE);
        AutoCrudServiceContext crudSvcContext = AutoCrudServiceContext.createAutoCrudServiceContext(svc.getContextMap());
        String uri = request.getRequestURI();
        String[] args = uri.split("/");
        if (args.length < 4) {
            throw new ServletException("Invalid request format");
        }
        int start_index = 0;
        for (int i = 0; i < args.length; ++i) {
            String tmp = args[i];
            if (!"autocrud".equals(tmp)) continue;
            start_index = i;
            break;
        }
        String object_name = args[start_index + 1];
        String operation_name = args[start_index + 2];
        BusinessModel bm = this.mDatabaseServiceFactory.getModelFactory().getModelForRead(object_name);
        if (bm == null) {
            throw new ServletException("Can't load model:" + object_name);
        }
        CompositeMap service_config = (CompositeMap)this.mServiceConfig.clone();
        svc.setName(object_name + "_" + operation_name);
        ScreenConfig screen = ScreenConfig.createScreenConfig(service_config);
        if (this.enableBMTrace) {
            screen.setTrace(true);
        }
        CompositeMap action_config = null;
        if ("query".equals(operation_name)) {
            ModelQueryConfig mq = ActionConfigManager.createModelQuery(object_name);
            mq.setParameters(svc.getServiceContext().getParameter());
            String cache_key = request.getParameter("_cachekey");
            if (cache_key != null) {
                mq.setCacheKey(uri + "." + cache_key);
            }
            mq.setAttribFromRequest(true);
            action_config = mq.getObjectContext();
            CompositeMap service_output = service_config.getChild("service-output");
            service_output.put("output", "/model/" + mq.getRootPath());
        } else if ("update".equals(operation_name)) {
            action_config = ActionConfigManager.createModelUpdate(object_name);
            this.prepareUpdateAction(svc.getServiceContext(), action_config);
        } else if ("insert".equals(operation_name)) {
            action_config = ActionConfigManager.createModelInsert(object_name);
        } else if ("delete".equals(operation_name)) {
            action_config = ActionConfigManager.createModelDelete(object_name);
        } else if ("batch_update".equals(operation_name)) {
            action_config = ActionConfigManager.createModelBatchUpdate(object_name);
            this.prepareUpdateAction(svc.getServiceContext(), action_config);
        } else if ("execute".equals(operation_name)) {
            action_config = ActionConfigManager.createModelAction("model-execute", object_name);
        } else {
            throw new ServletException("Unknown command:" + operation_name);
        }
        CompositeMap proc_config = screen.getInitProcedureConfig();
        proc_config.addChild(0, action_config);
        String dump_context = request.getParameter("_dump_context");
        if ("true".equals(dump_context)) {
            proc_config.addChild(new CompositeMap("p", "uncertain.proc", "echo"));
        }
        svc.setServiceConfigData(service_config);
        crudSvcContext.setAutoCrudService(true);
        crudSvcContext.setRequestedBM(object_name);
        crudSvcContext.setRequestedOperation(operation_name);
    }
}

