/*
 * Decompiled with CFR 0.152.
 */
package aurora.service.validation;

import aurora.service.validation.DatatypeMismatchException;
import aurora.service.validation.FieldValidationException;
import aurora.service.validation.IParameter;
import aurora.service.validation.IParameterIterator;
import aurora.service.validation.ParameterNullException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import uncertain.composite.CompositeMap;
import uncertain.datatype.DataType;
import uncertain.datatype.DataTypeRegistry;

public class ParameterParser {
    static ParameterParser default_instance = new ParameterParser();
    DataTypeRegistry registry;

    public static ParameterParser getInstance() {
        return default_instance;
    }

    public ParameterParser() {
        this.registry = DataTypeRegistry.getInstance();
    }

    public ParameterParser(DataTypeRegistry registry) {
        this.registry = registry;
    }

    void parseSingleParameter(CompositeMap input, IParameter param) throws FieldValidationException {
        DataType dt;
        String datatype = param.getDataType();
        if (datatype == null) {
            datatype = "java.lang.String";
        }
        if ((dt = this.registry.getDataType(datatype)) == null) {
            throw new IllegalArgumentException("can't find data type " + param.getDataType() + " in parameter " + param.getName());
        }
        Object value = input.get(param.getName());
        if (value == null && (value = param.getDefaultValue()) == null && param.isRequired()) {
            throw new ParameterNullException(param.getName());
        }
        Object parsed_value = null;
        if (value != null && !dt.getJavaType().isAssignableFrom(value.getClass())) {
            try {
                parsed_value = dt.convert(value);
            }
            catch (Exception ex) {
                throw new DatatypeMismatchException(dt.getJavaType(), param.getName(), value, ex);
            }
            input.put(param.getName(), parsed_value);
        }
    }

    public List parse(CompositeMap input, IParameterIterator params) {
        LinkedList<Exception> errors = null;
        while (params.hasNext()) {
            IParameter param = params.next();
            try {
                this.parseSingleParameter(input, param);
            }
            catch (Exception ex) {
                if (errors == null) {
                    errors = new LinkedList<Exception>();
                }
                errors.add(ex);
            }
        }
        return errors;
    }

    public List parse(CompositeMap input, List param_iterator_list) {
        Iterator it = param_iterator_list.iterator();
        List errors = null;
        while (it.hasNext()) {
            IParameterIterator params = (IParameterIterator)it.next();
            List lst = this.parse(input, params);
            if (lst == null) continue;
            if (errors == null) {
                errors = lst;
                continue;
            }
            errors.addAll(lst);
        }
        return errors;
    }
}

