/*
 * Decompiled with CFR 0.152.
 */
package uncertain.cache;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import uncertain.cache.ICache;
import uncertain.cache.IReadWriteLockable;

public class ConcurrentCache
implements ICache,
IReadWriteLockable {
    ICache cache;
    ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    ReentrantReadWriteLock.WriteLock write = this.lock.writeLock();
    ReentrantReadWriteLock.ReadLock read = this.lock.readLock();

    public ConcurrentCache(ICache cache) {
        this.cache = cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getValue(Object key) {
        this.read.lock();
        try {
            Object object = this.cache.getValue(key);
            return object;
        }
        finally {
            this.read.unlock();
        }
    }

    @Override
    public boolean setValue(Object key, Object value) {
        return this.cache.setValue(key, value);
    }

    @Override
    public boolean setValue(Object key, int timeout, Object value) {
        return this.cache.setValue(key, timeout, value);
    }

    @Override
    public void remove(Object key) {
        this.cache.remove(key);
    }

    @Override
    public void clear() {
        this.cache.clear();
    }

    @Override
    public Lock readLock() {
        return this.read;
    }

    @Override
    public Lock writeLock() {
        return this.write;
    }
}

