/*
 * Decompiled with CFR 0.152.
 */
package uncertain.composite;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import uncertain.composite.CompositeMap;
import uncertain.composite.IterationHandle;
import uncertain.composite.QualifiedName;
import uncertain.composite.TextParser;
import uncertain.util.GroupObjectProcessorImpl;
import uncertain.util.IGroupObjectProcessor;
import uncertain.util.IRecordFilter;

public class CompositeUtil {
    public static final String ANY_VALUE = "*";
    public static final String NULL_VALUE = "null";

    public static Map getPrefixMapping(CompositeMap map) {
        PrefixMappingHolder holder = new PrefixMappingHolder();
        map.iterate(holder, true);
        Map prefix_mapping = holder.getPrefixMapping();
        return prefix_mapping;
    }

    static boolean compare(Object field, String value) {
        if (field == null) {
            if (value == null) {
                return true;
            }
            return NULL_VALUE.equals(value);
        }
        if (ANY_VALUE.equals(value)) {
            return true;
        }
        return field.toString().equals(value);
    }

    public static boolean compareObject(CompositeMap map, String access_path, String value) {
        Object obj = map.getObject(access_path);
        String parsed_value = TextParser.parse(value, map);
        return CompositeUtil.compare(obj, parsed_value);
    }

    public static boolean compareObjectDirect(CompositeMap map, String access_path, String value) {
        Object obj = map.getObject(access_path);
        return CompositeUtil.compare(obj, value);
    }

    public static CompositeMap findChild(CompositeMap root, String elementName, String attribName, String value) {
        if (root == null) {
            return null;
        }
        ChildFinder cf = new ChildFinder(elementName, attribName, value);
        root.iterate(cf, true);
        return cf.getResult();
    }

    public static CompositeMap findChild(CompositeMap root, QualifiedName qName) {
        if (root == null) {
            return null;
        }
        List childs = root.getChilds();
        if (childs == null) {
            return null;
        }
        for (CompositeMap node : childs) {
            QualifiedName nm = node.getQName();
            if (nm == null || !nm.equals(qName)) continue;
            return node;
        }
        return null;
    }

    public static CompositeMap findChild(CompositeMap root, String elementName) {
        if (root == null) {
            return null;
        }
        ChildFinder cf = new ChildFinder(elementName, null, null);
        root.iterate(cf, true);
        return cf.getResult();
    }

    public static List findChilds(CompositeMap root, String elementName, String attribName, String value) {
        if (root == null) {
            return null;
        }
        ChildsFinder cf = new ChildsFinder(elementName, attribName, value);
        root.iterate(cf, true);
        return cf.getResult();
    }

    public static List findChilds(CompositeMap root, String elementName) {
        if (root == null) {
            return null;
        }
        ChildsFinder cf = new ChildsFinder(elementName, null, null);
        root.iterate(cf, true);
        return cf.getResult();
    }

    public static CompositeMap findParentWithName(CompositeMap map, String element_name) {
        for (CompositeMap parent = map.getParent(); parent != null; parent = parent.getParent()) {
            if (element_name == null || !element_name.equals(parent.getName())) continue;
            return parent;
        }
        return null;
    }

    static int getFunctionType(String name) {
        String[] funs = IGroupObjectProcessor.GROUP_FUNCITONS;
        for (int i = 0; i < funs.length; ++i) {
            if (!funs[i].equalsIgnoreCase(name)) continue;
            return i;
        }
        return -1;
    }

    static Object getResult(int type, Collection list, String field) {
        if (list == null) {
            return null;
        }
        GroupObjectProcessorImpl gp = new GroupObjectProcessorImpl(type);
        for (CompositeMap m : list) {
            Object o = m.getObject(field);
            if (o == null) continue;
            gp.process(o);
        }
        return gp.getObject();
    }

    public static Object groupResult(CompositeMap root, String field, String function) {
        int type = CompositeUtil.getFunctionType(function);
        if (type < 0) {
            throw new IllegalArgumentException("function " + function + " is not defined");
        }
        List childs = root.getChilds();
        return CompositeUtil.getResult(type, childs, field);
    }

    private static String getKey(CompositeMap map, Object[] keys) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < keys.length; ++i) {
            buf.append(map.get(keys[i]));
        }
        return buf.toString();
    }

    public static void join(Collection list1, Collection list2, Object[] key_fields) {
        String key;
        HashMap<String, CompositeMap> join_index = new HashMap<String, CompositeMap>();
        for (CompositeMap item : list1) {
            key = CompositeUtil.getKey(item, key_fields);
            join_index.put(key, item);
        }
        for (CompositeMap source : list2) {
            key = CompositeUtil.getKey(source, key_fields);
            CompositeMap target = (CompositeMap)join_index.get(key);
            if (target == null) continue;
            target.putAll(source);
        }
        join_index.clear();
    }

    public static CompositeMap collapse(CompositeMap root) {
        List childs = root.getChilds();
        if (childs == null) {
            return root;
        }
        ListIterator it = childs.listIterator();
        while (it.hasNext()) {
            CompositeMap child = (CompositeMap)it.next();
            String text = child.getText();
            if (child.size() == 0 && text != null && !"".equals(text.trim())) {
                root.put(child.getName(), text);
                it.remove();
                continue;
            }
            CompositeUtil.collapse(child);
        }
        return root;
    }

    public static CompositeMap expand(CompositeMap root) {
        List childs = root.getChilds();
        if (childs != null) {
            ListIterator it = childs.listIterator();
            while (it.hasNext()) {
                CompositeMap child = (CompositeMap)it.next();
                CompositeUtil.expand(child);
            }
        }
        Set keyset = root.keySet();
        Iterator it = keyset.iterator();
        while (it.hasNext()) {
            String key = it.next().toString();
            CompositeMap keychild = new CompositeMap(key);
            keychild.setText(root.getString(key));
            root.addChild(keychild);
        }
        HashSet hs = new HashSet();
        hs.addAll(keyset);
        for (Object key : hs) {
            root.remove(key);
        }
        return root;
    }

    public static int uniqueHashCode(CompositeMap m) {
        return System.identityHashCode(m);
    }

    public static Object[][] toArray(CompositeMap m, String[] fields, IRecordFilter filter) {
        List childs = m.getChilds();
        if (childs == null) {
            return null;
        }
        Object[][] data = new Object[childs.size()][fields.length];
        Iterator it = childs.iterator();
        int row = 0;
        while (it.hasNext()) {
            CompositeMap record = (CompositeMap)it.next();
            if (filter != null && !filter.accepts(record)) continue;
            for (int col = 0; col < fields.length; ++col) {
                data[row][col] = record.get(fields[col]);
            }
            ++row;
        }
        return data;
    }

    public static void fillMap(Map target, CompositeMap data, Object key_field) {
        Iterator it = data.getChildIterator();
        if (it == null) {
            return;
        }
        while (it.hasNext()) {
            CompositeMap item = (CompositeMap)it.next();
            Object key = item.get(key_field);
            target.put(key, item);
        }
    }

    public static void fillMap(Map target, CompositeMap data, Object key_field, Object value_field) {
        Iterator it = data.getChildIterator();
        if (it == null) {
            return;
        }
        while (it.hasNext()) {
            CompositeMap item = (CompositeMap)it.next();
            Object key = item.get(key_field);
            Object value = item.get(value_field);
            target.put(key, value);
        }
    }

    public static Object[][] toArray(CompositeMap m, String[] fields) {
        return CompositeUtil.toArray(m, fields, null);
    }

    public static String connectAttribute(CompositeMap root, String attrib_name, String separator) {
        if (root == null) {
            return null;
        }
        Iterator it = root.getChildIterator();
        if (it == null) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        int id = 0;
        while (it.hasNext()) {
            CompositeMap child = (CompositeMap)it.next();
            Object value = child.get(attrib_name);
            if (id > 0) {
                result.append(separator);
            }
            result.append(value);
            ++id;
        }
        return result.toString();
    }

    public static String connectAttribute(CompositeMap root, String attrib_name) {
        return CompositeUtil.connectAttribute(root, attrib_name, ",");
    }

    public static void copyAttributes(Map source, Map dest) {
        for (Map.Entry entry : source.entrySet()) {
            if (dest.containsKey(entry.getKey())) continue;
            dest.put(entry.getKey(), entry.getValue());
        }
    }

    public static void mergeChildsByOverride(CompositeMap source, CompositeMap dest, Object key) {
        Iterator it = source.getChildIterator();
        if (it == null) {
            return;
        }
        HashMap dest_cache = new HashMap();
        CompositeUtil.fillMap(dest_cache, dest, key);
        while (it.hasNext()) {
            CompositeMap source_item = (CompositeMap)it.next();
            Object value = source_item.get(key);
            CompositeMap dest_item = (CompositeMap)dest_cache.get(value);
            if (dest_item != null) {
                CompositeUtil.copyAttributes(source_item, dest_item);
                continue;
            }
            dest.addChild((CompositeMap)source_item.clone());
        }
        dest_cache.clear();
    }

    public static void mergeChildsByReference(CompositeMap source, CompositeMap dest, Object key) {
        Iterator it = dest.getChildIterator();
        if (it == null) {
            return;
        }
        HashMap source_cache = new HashMap();
        CompositeUtil.fillMap(source_cache, source, key);
        while (it.hasNext()) {
            CompositeMap dest_item = (CompositeMap)it.next();
            Object value = dest_item.get(key);
            CompositeMap source_item = (CompositeMap)source_cache.get(value);
            if (source_item == null) continue;
            CompositeUtil.copyAttributes(source_item, dest_item);
        }
        source_cache.clear();
    }

    public static void getLevelChilds(CompositeMap source, int level, List result) {
        if (source == null) {
            return;
        }
        if (level == 0) {
            result.add(source);
        }
        if (source.getChilds() == null) {
            return;
        }
        if (level == 1) {
            result.addAll(source.getChilds());
        } else if (level > 1) {
            Iterator it = source.getChildIterator();
            while (it.hasNext()) {
                CompositeUtil.getLevelChilds((CompositeMap)it.next(), level - 1, result);
            }
        }
    }

    public static class PrefixMappingHolder
    implements IterationHandle {
        static final String ns_prefix = "ns";
        int sequence = 1;
        Set prefix_set = new HashSet();
        Map prefix_map = new HashMap();

        public String getUniquePrefix() {
            String prefix = ns_prefix + this.sequence++;
            while (this.prefix_set.contains(prefix)) {
                prefix = ns_prefix + this.sequence++;
            }
            return prefix;
        }

        @Override
        public int process(CompositeMap map) {
            String url = map.getNamespaceURI();
            Map mapping = map.getNamespaceMapping();
            if (mapping != null) {
                this.prefix_map.putAll(mapping);
            }
            if (url != null && !this.prefix_map.containsKey(url)) {
                String prefix = map.getPrefix();
                if (prefix == null) {
                    prefix = this.getUniquePrefix();
                }
                if (this.prefix_set.contains(prefix)) {
                    prefix = this.getUniquePrefix();
                }
                this.prefix_set.add(prefix);
                this.prefix_map.put(url, prefix);
            }
            return 0;
        }

        public Map getPrefixMapping() {
            return this.prefix_map;
        }
    }

    public static class ChildsFinder
    implements IterationHandle {
        private String element_name;
        private String attrib_name;
        private String attrib_value;
        private LinkedList result = new LinkedList();

        public LinkedList getResult() {
            return this.result;
        }

        @Override
        public int process(CompositeMap map) {
            if (this.element_name != null && !CompositeUtil.compare(map.getName(), this.element_name)) {
                return 0;
            }
            if (this.attrib_name != null) {
                Object vl = map.get(this.attrib_name);
                if (CompositeUtil.compare(vl, this.attrib_value)) {
                    this.result.add(map);
                }
            } else {
                this.result.add(map);
            }
            return 0;
        }

        public ChildsFinder(String element_name, String attrib_name, String attrib_value) {
            this.element_name = element_name;
            this.attrib_name = attrib_name;
            this.attrib_value = attrib_value;
        }
    }

    public static class ChildFinder
    implements IterationHandle {
        public String element_name;
        public String attrib_name;
        public String attrib_value;
        CompositeMap result;

        public CompositeMap getResult() {
            return this.result;
        }

        @Override
        public int process(CompositeMap map) {
            if (this.element_name != null && !CompositeUtil.compare(map.getName(), this.element_name)) {
                return 0;
            }
            if (this.attrib_name != null) {
                Object vl = map.get(this.attrib_name);
                if (CompositeUtil.compare(vl, this.attrib_value)) {
                    this.result = map;
                    return 2;
                }
            } else {
                this.result = map;
                return 2;
            }
            return 0;
        }

        public ChildFinder(String element_name, String attrib_name, String attrib_value) {
            this.element_name = element_name;
            this.attrib_name = attrib_name;
            this.attrib_value = attrib_value;
        }
    }
}

