/*
 * Decompiled with CFR 0.152.
 */
package uncertain.composite.decorate;

import uncertain.composite.CompositeMap;
import uncertain.composite.DynamicObject;
import uncertain.composite.decorate.ICompositeDecorator;
import uncertain.core.ConfigurationError;

public class AttributeModify
extends DynamicObject
implements ICompositeDecorator {
    public static final String ATTRIBUTE_SET = "attribute-set";
    public static final String ATTRIBUTE_REMOVE = "attribute-remove";
    public static final String ATTRIBUTE_SET_BY_PATTERN = "attribute-set-by-pattern";
    public static final String KEY_NAME = "name";
    public static final String KEY_VALUE = "value";

    static AttributeModify createInstance(String name) {
        CompositeMap map = new CompositeMap(name);
        AttributeModify e = new AttributeModify();
        e.initialize(map);
        return e;
    }

    public static AttributeModify createAttributeSet(String name) {
        return AttributeModify.createInstance(ATTRIBUTE_SET);
    }

    public static AttributeModify createAttributeSet(String name, Object value) {
        AttributeModify m = AttributeModify.createInstance(ATTRIBUTE_SET);
        m.setName(name);
        m.setValue(value);
        return m;
    }

    public static AttributeModify createAttributeRemove(String name) {
        AttributeModify m = AttributeModify.createInstance(ATTRIBUTE_REMOVE);
        m.setName(name);
        return m;
    }

    public String getName() {
        return this.getString(KEY_NAME);
    }

    public void setName(String name) {
        this.putString(KEY_NAME, name);
    }

    public void setValue(Object obj) {
        this.put(KEY_VALUE, obj);
    }

    public Object getValue() {
        return this.get(KEY_VALUE);
    }

    public void setNameValue(String name, Object value) {
        this.setName(name);
        this.setValue(value);
    }

    @Override
    public CompositeMap process(CompositeMap source) {
        String action = this.getObjectContext().getName();
        String name = this.getName();
        if (ATTRIBUTE_SET.equalsIgnoreCase(action)) {
            if (name == null) {
                throw new ConfigurationError("Must set 'name' property for <attribute-set> ");
            }
            source.put(this.getName(), this.getValue());
        } else if (ATTRIBUTE_REMOVE.equalsIgnoreCase(action)) {
            if (name == null) {
                throw new ConfigurationError("Must set 'name' property for <attribute-remove> ");
            }
            source.remove(name);
        }
        return source;
    }
}

