/*
 * Decompiled with CFR 0.152.
 */
package uncertain.ocm;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.logging.Level;
import uncertain.composite.CompositeLoader;
import uncertain.composite.CompositeMap;
import uncertain.datatype.DataTypeRegistry;
import uncertain.logging.DefaultLogger;
import uncertain.logging.ILogger;
import uncertain.logging.ILoggerProvider;
import uncertain.ocm.ClassRegistry;
import uncertain.ocm.IConfigurable;
import uncertain.ocm.IConfigureListener;
import uncertain.ocm.IMappingHandle;
import uncertain.ocm.IOCMEventListener;
import uncertain.ocm.IObjectCreator;
import uncertain.ocm.MappingRule;
import uncertain.ocm.OCMEvent;
import uncertain.ocm.OCMEventFactory;
import uncertain.ocm.ObjectAccessor;
import uncertain.ocm.ObjectRegistryImpl;
import uncertain.ocm.ReflectionMapper;

public class OCManager
implements IMappingHandle {
    public static final String LOGGING_TOPIC = "uncertain.ocm";
    HashMap classMap;
    ClassRegistry classRegistry;
    IObjectCreator objectCreator;
    ReflectionMapper default_mapper;
    LinkedList listener_list;
    ILogger logger;
    ILoggerProvider mLoggerProvider;
    DataTypeRegistry datatype_home;
    boolean event_enable = true;
    static OCManager default_instance = new OCManager();
    static CompositeLoader default_loader = CompositeLoader.createInstanceForOCM();

    public static CompositeLoader getDefaultCompositeLoader() {
        return default_loader;
    }

    public static OCManager getInstance() {
        return default_instance;
    }

    void createDefaultLogger() {
        this.logger = new DefaultLogger(LOGGING_TOPIC);
        this.logger.setLevel(Level.WARNING);
    }

    private void _init() {
        this.classMap = new HashMap(1000);
        this.default_mapper = new ReflectionMapper(this);
        this.classRegistry = new ClassRegistry();
        this.datatype_home = DataTypeRegistry.getInstance();
        this.createDefaultLogger();
    }

    public OCManager() {
        this._init();
        this.objectCreator = new ObjectRegistryImpl();
    }

    public OCManager(IObjectCreator obj_creator) {
        this._init();
        this.objectCreator = obj_creator;
    }

    public IObjectCreator getObjectCreator() {
        return this.objectCreator;
    }

    public void setObjectCreator(IObjectCreator objectCreator) {
        this.objectCreator = objectCreator;
    }

    public void addListener(IOCMEventListener listener) {
        if (this.listener_list == null) {
            this.listener_list = new LinkedList();
        }
        this.listener_list.add(listener);
        this.setEventEnable(true);
    }

    public boolean isEventEnable() {
        return this.event_enable;
    }

    public void setEventEnable(boolean enable) {
        this.event_enable = enable;
    }

    void fireEvent(OCMEvent evt) {
        if (this.isEventEnable() && this.listener_list != null) {
            for (IOCMEventListener listener : this.listener_list) {
                listener.onEvent(evt);
            }
        }
    }

    public Class getMappedClass(CompositeMap container) {
        if (container == null) {
            throw new NullPointerException();
        }
        String cls_name = this.classRegistry.getClassName(container);
        if (cls_name == null) {
            return null;
        }
        if (this.classMap.containsKey(cls_name)) {
            return (Class)this.classMap.get(cls_name);
        }
        Class<?> cls = null;
        try {
            cls = Class.forName(cls_name);
        }
        catch (ClassNotFoundException ex) {
            this.fireEvent(OCMEventFactory.newClassNotFoundEvent(this, cls_name));
        }
        this.classMap.put(cls_name, cls);
        return cls;
    }

    @Override
    public Object createNewInstance(CompositeMap container) {
        Class cls = this.getMappedClass(container);
        if (cls == null) {
            return null;
        }
        Object obj = null;
        try {
            obj = this.objectCreator.createInstance(cls);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        return obj;
    }

    void populateObjectInternal(CompositeMap container, Object obj, IMappingHandle handle) {
        if (obj instanceof IConfigurable) {
            ((IConfigurable)obj).beginConfigure(container);
        }
        this.default_mapper.toObject(container, obj, handle);
        if (obj instanceof IConfigureListener) {
            ((IConfigureListener)obj).endConfigure();
        }
        if (this.isEventEnable()) {
            this.fireEvent(OCMEventFactory.newObjectCreatedEvent(this, obj));
        }
    }

    public boolean canCreateInstance(CompositeMap container) {
        return this.getMappedClass(container) != null;
    }

    public Object createObject(CompositeMap container) {
        assert (container != null);
        Object obj = this.createNewInstance(container);
        if (obj != null) {
            this.populateObjectInternal(container, obj, this);
        }
        return obj;
    }

    public Object createObject(CompositeMap container, IMappingHandle handle) {
        Object obj = handle.createNewInstance(container);
        if (obj != null) {
            this.populateObjectInternal(container, obj, handle);
        }
        return obj;
    }

    @Override
    public void getUnknownContainer(CompositeMap container) {
    }

    @Override
    public boolean acceptUnknownContainer() {
        return false;
    }

    public CompositeMap createContainer(Object obj) {
        return null;
    }

    public void populateObject(CompositeMap container, Object obj) {
        if (obj instanceof IConfigurable) {
            ((IConfigurable)obj).beginConfigure(container);
        }
        this.default_mapper.toObject(container, obj);
        if (obj instanceof IConfigurable) {
            ((IConfigurable)obj).endConfigure();
        }
    }

    public void populateObject(CompositeMap container, Object obj, IMappingHandle handle) {
        if (obj instanceof IConfigurable) {
            ((IConfigurable)obj).beginConfigure(container);
        }
        this.default_mapper.toObject(container, obj, handle);
        if (obj instanceof IConfigurable) {
            ((IConfigurable)obj).endConfigure();
        }
    }

    ReflectionMapper getDefaultMapper() {
        return this.default_mapper;
    }

    public ClassRegistry getClassRegistry() {
        return this.classRegistry;
    }

    public void setClassRegistry(ClassRegistry classRegistry) {
        this.classRegistry = classRegistry;
    }

    public ILogger getLogger() {
        return this.logger;
    }

    public void setLogger(ILogger logger) {
        this.logger = logger;
    }

    public void handleException(String message, Throwable thr) {
        if (thr instanceof Error) {
            throw (Error)thr;
        }
        Throwable t = thr;
        while (t.getCause() != null) {
            t = t.getCause();
        }
        throw new RuntimeException(t);
    }

    public ReflectionMapper getReflectionMapper() {
        return this.default_mapper;
    }

    public ObjectAccessor getAccessor(Class cls, String field_name) {
        MappingRule rule = this.default_mapper.getMappingRule(cls);
        if (rule == null) {
            return null;
        }
        ObjectAccessor oac = (ObjectAccessor)rule.getAttributeMapping().get(field_name.toLowerCase());
        return oac;
    }

    public void setAttribute(Object obj, String field_name, Object value) throws Exception {
        ObjectAccessor oac = this.getAccessor(obj.getClass(), field_name);
        if (oac != null) {
            oac.writeToObject(obj, value);
        }
    }

    public Object getAttribute(Object obj, String field_name) throws Exception {
        ObjectAccessor oac = this.getAccessor(obj.getClass(), field_name);
        if (oac == null) {
            return null;
        }
        return oac.readFromObject(obj);
    }

    public DataTypeRegistry getDataTypeHome() {
        return this.datatype_home;
    }

    public void setDataTypeHome(DataTypeRegistry datatype_home) {
        this.datatype_home = datatype_home;
    }

    public ILoggerProvider getLoggerProvider() {
        return this.mLoggerProvider;
    }

    public void setLoggerProvider(ILoggerProvider loggerProvider) {
        this.mLoggerProvider = loggerProvider;
        this.logger = loggerProvider.getLogger(LOGGING_TOPIC);
    }
}

