/*
 * Decompiled with CFR 0.152.
 */
package uncertain.util.reflect;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import uncertain.util.reflect.ClassIterateHandle;

public class ClassIterator {
    public void iterate(Class cls, ClassIterateHandle handle) throws SecurityException {
        int n;
        handle.beginIterate(cls);
        Method[] methods = cls.getMethods();
        for (n = 0; n < methods.length; ++n) {
            handle.onMethod(cls, methods[n]);
        }
        Class<?>[] itfcs = cls.getInterfaces();
        for (n = 0; n < itfcs.length; ++n) {
            handle.onInterface(cls, itfcs[n]);
        }
        Constructor<?>[] cts = cls.getConstructors();
        for (n = 0; n < cts.length; ++n) {
            handle.onConstructor(cls, cts[n]);
        }
        Field[] flds = cls.getFields();
        for (n = 0; n < flds.length; ++n) {
            handle.onField(cls, flds[n]);
        }
        handle.endIterate(cls);
    }
}

