/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.poi;

import aurora.plugin.poi.BigGridUtil;
import java.io.IOException;
import java.io.Writer;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellReference;
import org.apache.xerces.util.XMLChar;

public class SpreadsheetWriter {
    private final Writer _out;
    private int _rownum;
    private String xmlEncoding = "UTF-8";
    private List mergedRegionList = new LinkedList();
    private Map<Integer, Short> columnWidthMap = new TreeMap<Integer, Short>();

    public SpreadsheetWriter(Writer out) {
        this._out = out;
    }

    public SpreadsheetWriter(Writer out, String xmlEncoding) {
        this._out = out;
        this.xmlEncoding = xmlEncoding;
    }

    public void beginSheet() throws IOException {
        this._out.write("<?xml version=\"1.0\" encoding=\"" + this.xmlEncoding + "\"?>" + "<worksheet xmlns=\"http://schemas.openxmlformats.org/spreadsheetml/2006/main\">");
        if (!this.columnWidthMap.isEmpty()) {
            this._out.write("<cols>");
            Set<Integer> keySet = this.columnWidthMap.keySet();
            for (Integer col : keySet) {
                this._out.write("<col min=\"" + col + "\" max=\"" + col + "\" width=\"" + this.columnWidthMap.get(col) + "\" customWidth=\"1\"/>");
            }
            this._out.write("</cols>");
        }
        this._out.write("<sheetData>\n");
    }

    public void endSheet() throws IOException {
        this._out.write("</sheetData>");
        if (!this.mergedRegionList.isEmpty()) {
            this._out.write("<mergeCells>");
            BigGridUtil.sortList(this.mergedRegionList);
            int l = this.mergedRegionList.size();
            for (int i = 0; i < l; ++i) {
                this._out.write("<mergeCell ref=\"" + this.mergedRegionList.get(i) + "\"/>");
            }
            this._out.write("</mergeCells>");
        }
        this._out.write("</worksheet>");
    }

    public void insertRow(int rownum) throws IOException {
        this._out.write("<row r=\"" + (rownum + 1) + "\">\n");
        this._rownum = rownum;
    }

    public void endRow() throws IOException {
        this._out.write("</row>\n");
    }

    public void createCell(int columnIndex, String value, int styleIndex) throws IOException {
        String ref = new CellReference(this._rownum, columnIndex).formatAsString();
        this._out.write("<c r=\"" + ref + "\" t=\"inlineStr\"");
        if (styleIndex != -1) {
            this._out.write(" s=\"" + styleIndex + "\"");
        }
        this._out.write(">");
        this._out.write("<is><t>" + this.santizeForXml(value) + "</t></is>");
        this._out.write("</c>");
    }

    public void createCell(int columnIndex, String value) throws IOException {
        this.createCell(columnIndex, value, -1);
    }

    public void createCell(int columnIndex, double value, int styleIndex) throws IOException {
        String ref = new CellReference(this._rownum, columnIndex).formatAsString();
        this._out.write("<c r=\"" + ref + "\" t=\"n\"");
        if (styleIndex != -1) {
            this._out.write(" s=\"" + styleIndex + "\"");
        }
        this._out.write(">");
        this._out.write("<v>" + value + "</v>");
        this._out.write("</c>");
    }

    public void createCell(int columnIndex, double value) throws IOException {
        this.createCell(columnIndex, value, -1);
    }

    public void createCell(int columnIndex, boolean value) throws IOException {
        this.createCell(columnIndex, value, -1);
    }

    public void createCell(int columnIndex, boolean value, int styleIndex) throws IOException {
        String ref = new CellReference(this._rownum, columnIndex).formatAsString();
        this._out.write("<c r=\"" + ref + "\" t=\"b\"");
        if (styleIndex != -1) {
            this._out.write(" s=\"" + styleIndex + "\"");
        }
        this._out.write(">");
        this._out.write("<v>" + (value ? 1 : 0) + "</v>");
        this._out.write("</c>");
    }

    public void createCell(int columnIndex, Calendar value, int styleIndex) throws IOException {
        this.createCell(columnIndex, DateUtil.getExcelDate((Calendar)value, (boolean)false), styleIndex);
    }

    public void createCell(int columnIndex, Date value, int styleIndex) throws IOException {
        this.createCell(columnIndex, DateUtil.getExcelDate((Date)value, (boolean)false), styleIndex);
    }

    private String cData(String str) {
        return "<![CDATA[" + str + "]]>";
    }

    private String santizeForXml(String str) {
        StringBuilder strBuilder = new StringBuilder();
        boolean stringHasSpecial = false;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (XMLChar.isInvalid((int)c)) continue;
            strBuilder.append(c);
            stringHasSpecial = stringHasSpecial || this.charIsSpecial(c);
        }
        if (stringHasSpecial) {
            return this.cData(strBuilder.toString());
        }
        return strBuilder.toString();
    }

    private boolean charIsSpecial(char c) {
        return c == '&' || c == '<' || c == '>';
    }

    public void addMergedRegion(CellRangeAddress range) {
        this.mergedRegionList.add(range.formatAsString());
    }

    public void setCellWidth(int columnIndex, short width) {
        this.columnWidthMap.put(columnIndex, width);
    }

    public void close() throws IOException {
        if (this._out != null) {
            this._out.close();
        }
    }
}

