/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.yeepay;

import aurora.plugin.yeepay.YeePay;
import aurora.service.ServiceContext;
import aurora.service.ServiceInstance;
import aurora.service.http.HttpServiceInstance;
import com.yeepay.PaymentForOnlineService;
import com.yeepay.RefundResult;
import javax.servlet.http.HttpServletRequest;
import uncertain.composite.CompositeMap;
import uncertain.composite.TextParser;
import uncertain.proc.AbstractEntry;
import uncertain.proc.ProcedureRunner;

public class Refund
extends AbstractEntry {
    private String trxID;
    private String amt;
    private String cur;
    private String desc;

    public String getTrxID() {
        return this.trxID;
    }

    public void setTrxID(String trxID) {
        this.trxID = trxID;
    }

    public String getAmt() {
        return this.amt;
    }

    public void setAmt(String amt) {
        this.amt = amt;
    }

    public String getCur() {
        return this.cur;
    }

    public void setCur(String cur) {
        this.cur = cur;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public void run(ProcedureRunner runner) throws Exception {
        CompositeMap context = runner.getContext();
        HttpServiceInstance serviceInstance = (HttpServiceInstance)ServiceInstance.getInstance((CompositeMap)context);
        HttpServletRequest request = serviceInstance.getRequest();
        request.setCharacterEncoding("GBK");
        ServiceContext service = ServiceContext.createServiceContext((CompositeMap)context);
        CompositeMap model = service.getModel();
        String pb_TrxId = YeePay.formatString(this.getValue(context, this.getTrxID()));
        String p3_Amt = YeePay.formatString(this.getValue(context, this.getAmt()));
        String p4_Cur = YeePay.formatString("CNY");
        String p5_Desc = YeePay.formatString(this.getValue(context, this.getDesc()));
        try {
            RefundResult rr = PaymentForOnlineService.refundByTrxId((String)pb_TrxId, (String)p3_Amt, (String)p4_Cur, (String)p5_Desc);
            model.put((Object)"r0_Cmd", (Object)rr.getR0_Cmd());
            model.put((Object)"r1_Code", (Object)rr.getR1_Code());
            model.put((Object)"r2_TrxId", (Object)rr.getR2_TrxId());
            model.put((Object)"r3_Amt", (Object)rr.getR3_Amt());
            model.put((Object)"r4_Cur", (Object)rr.getR4_Cur());
        }
        catch (Exception e) {
            this.catchException(model, e);
        }
    }

    private void catchException(CompositeMap model, Exception e) throws Exception {
        if (e instanceof RuntimeException) {
            String message = e.getMessage();
            String[] split = message.split(":");
            if (split.length != 2) {
                throw e;
            }
            if ("Query fail.Error code".equals(split[0])) {
                try {
                    model.put((Object)"r1_Code", (Object)Integer.valueOf(split[1]));
                }
                catch (NumberFormatException nfe) {
                    throw e;
                }
            }
        } else {
            throw e;
        }
    }

    private String getValue(CompositeMap context, String key) {
        if (key != null) {
            return TextParser.parse((String)key, (CompositeMap)context);
        }
        return null;
    }

    public static void main(String[] args) {
    }
}

