/*
 * Decompiled with CFR 0.152.
 */
package aurora.presentation.component.std;

import aurora.presentation.BuildSession;
import aurora.presentation.ViewContext;
import aurora.presentation.component.std.Component;
import java.io.IOException;
import java.util.Map;
import uncertain.composite.CompositeMap;
import uncertain.composite.TextParser;

public class Upload
extends Component {
    public static final String PROPERTITY_TEXT = "text";
    public static final String PROPERTITY_SOURCE_TYPE = "sourcetype";
    public static final String PROPERTITY_PK_VALUE = "pkvalue";
    public static final String PROPERTITY_FILE_SIZE = "filesize";
    public static final String PROPERTITY_FILE_TYPE = "filetype";
    public static final String PROPERTITY_BUTTON_WIDTH = "buttonwidth";
    public static final String PROPERTITY_UPLOAD_URL = "uploadurl";
    public static final String PROPERTITY_DELETE_URL = "deleteurl";
    public static final String PROPERTITY_DOWNLOAD_URL = "downloadurl";
    public static final String PROPERTITY_SHOW_DELETE = "showdelete";
    public static final String PROPERTITY_SHOW_UPLOAD = "showupload";

    @Override
    public void onPreparePageContent(BuildSession session, ViewContext context) throws IOException {
        super.onPreparePageContent(session, context);
        this.addStyleSheet(session, context, "table/Table-min.css");
        this.addStyleSheet(session, context, "upload/upload.css");
        this.addJavaScript(session, context, "table/Table-min.js");
        this.addJavaScript(session, context, "upload/swfupload.js");
        this.addJavaScript(session, context, "upload/swfupload.queue.js");
        this.addJavaScript(session, context, "upload/handler.js");
    }

    @Override
    public void onCreateViewContent(BuildSession session, ViewContext context) throws IOException {
        boolean showDelete;
        super.onCreateViewContent(session, context);
        CompositeMap view = context.getView();
        Map map = context.getMap();
        CompositeMap model = context.getModel();
        String id = view.getString("id");
        CompositeMap tb = new CompositeMap("table");
        tb.setNameSpaceURI("http://www.aurora-framework.org/application");
        tb.put("percentwidth", new Integer(100));
        tb.put("classname", "atmList");
        tb.put("showhead", new Boolean(false));
        tb.put("bindtarget", id + "_ds");
        tb.put("style", "border:none;background-color:#fff");
        CompositeMap tb_columns = new CompositeMap("columns");
        tb_columns.setNameSpaceURI("http://www.aurora-framework.org/application");
        tb.addChild(tb_columns);
        CompositeMap tb_column = new CompositeMap("column");
        tb_column.setNameSpaceURI("http://www.aurora-framework.org/application");
        tb_column.put("percentwidth", new Integer(100));
        tb_column.put("name", "file_name");
        boolean showUpload = view.getBoolean(PROPERTITY_SHOW_UPLOAD, true);
        if (!showUpload) {
            map.put(PROPERTITY_SHOW_UPLOAD, "none");
        }
        if (!(showDelete = view.getBoolean(PROPERTITY_SHOW_DELETE, true))) {
            tb_column.put("renderer", "atmNotDeleteRenderer");
        } else {
            tb_column.put("renderer", "atmRenderer");
        }
        tb_columns.addChild(tb_column);
        try {
            map.put("up_table", session.buildViewAsString(model, tb));
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
        String text = view.getString(PROPERTITY_TEXT, "upload");
        text = session.getLocalizedPrompt(text);
        map.put(PROPERTITY_TEXT, text);
        String st = view.getString(PROPERTITY_SOURCE_TYPE, PROPERTITY_SOURCE_TYPE);
        st = TextParser.parse(st, model);
        map.put(PROPERTITY_SOURCE_TYPE, st);
        String pk = view.getString(PROPERTITY_PK_VALUE, PROPERTITY_PK_VALUE);
        pk = TextParser.parse(pk, model);
        map.put(PROPERTITY_PK_VALUE, pk);
        String context_path = model.getObject("/request/@context_path").toString();
        map.put("context_path", context_path);
        map.put(PROPERTITY_BUTTON_WIDTH, new Integer(view.getInt(PROPERTITY_BUTTON_WIDTH, 50)));
        map.put(PROPERTITY_FILE_SIZE, new Integer(view.getInt(PROPERTITY_FILE_SIZE, 0)));
        map.put(PROPERTITY_FILE_TYPE, view.getString(PROPERTITY_FILE_TYPE, "*.*"));
        String uplloadUrl = view.getString(PROPERTITY_UPLOAD_URL, context_path + "/atm_upload.svc");
        map.put(PROPERTITY_UPLOAD_URL, TextParser.parse(uplloadUrl, model));
        String deleteUrl = view.getString(PROPERTITY_DELETE_URL, context_path + "/atm_delete.svc");
        map.put(PROPERTITY_DELETE_URL, TextParser.parse(deleteUrl, model));
        String downloadUrl = view.getString(PROPERTITY_DOWNLOAD_URL, context_path + "/atm_download.svc");
        map.put(PROPERTITY_DOWNLOAD_URL, TextParser.parse(downloadUrl, model));
        map.put("config", this.getConfigString());
    }
}

