/*
 * Decompiled with CFR 0.152.
 */
package aurora.service.http;

import aurora.service.IService;
import aurora.service.ServiceInstance;
import aurora.service.http.AbstractFacadeServlet;
import aurora.service.http.HttpServiceFactory;
import aurora.service.http.HttpServiceInstance;
import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.xml.sax.SAXException;
import uncertain.composite.CompositeMap;

public class FacadeServlet
extends AbstractFacadeServlet {
    private static final long serialVersionUID = -175392627883779860L;
    HttpServiceFactory mServiceFactory;

    public static String getServiceName(HttpServletRequest request) {
        String service_name = request.getServletPath();
        if (service_name.charAt(0) == '/') {
            service_name = service_name.substring(1);
        }
        return service_name;
    }

    @Override
    protected IService createServiceInstance(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String name = FacadeServlet.getServiceName(request);
        HttpServiceInstance svc = this.mServiceFactory.createHttpService(name, request, response, this);
        return svc;
    }

    @Override
    protected void populateService(HttpServletRequest request, HttpServletResponse response, IService service) throws Exception {
        ServiceInstance svc = (ServiceInstance)service;
        String name = svc.getName();
        CompositeMap config = this.mServiceFactory.loadServiceConfig(name);
        svc.setServiceConfigData(config, false);
        String extension = name.substring(name.lastIndexOf(46) + 1);
        String proc = this.mServiceFactory.getProcedureName(extension);
        svc.getController().setProcedureName(proc);
    }

    @Override
    protected void handleException(HttpServletRequest request, HttpServletResponse response, Throwable ex) throws IOException, ServletException {
        Throwable thr = ex.getCause();
        if (thr == null) {
            thr = ex;
        }
        if (!(thr instanceof SAXException)) {
            throw new ServletException(thr);
        }
        response.sendError(500, "error when parse screen file:" + thr.getMessage());
    }

    @Override
    protected void cleanUp(IService svc) {
        ((ServiceInstance)svc).clear();
    }

    @Override
    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.mServiceFactory = (HttpServiceFactory)this.mUncertainEngine.getObjectRegistry().getInstanceOfType(HttpServiceFactory.class);
        if (this.mServiceFactory == null) {
            throw new ServletException("No ServiceFactory instance registered in UncertainEngine");
        }
    }
}

