/*
 * Decompiled with CFR 0.152.
 */
package aurora.application.features;

import aurora.presentation.cache.IResponseCacheProvider;
import java.io.File;
import uncertain.cache.ICache;
import uncertain.cache.INamedCacheFactory;
import uncertain.core.IGlobalInstance;
import uncertain.core.ILifeCycle;
import uncertain.exception.GeneralException;
import uncertain.ocm.AbstractLocatableObject;
import uncertain.util.resource.ISourceFile;
import uncertain.util.resource.ISourceFileManager;

public class ResponseCacheProvider
extends AbstractLocatableObject
implements IResponseCacheProvider,
IGlobalInstance,
ILifeCycle {
    public static final String DEFAULT_SCREEN_CACHE_NAME = "ResponseCache";
    public static final String DEFAULT_KEY_PREFIX = "${/session/@lang}";
    String mResponseCacheKeyPrefix = "${/session/@lang}";
    String mResponseCacheName = "ResponseCache";
    ICache mResponseCache;
    INamedCacheFactory mCacheFactory;
    ISourceFileManager mSourceFileManager;

    public ResponseCacheProvider(INamedCacheFactory mCacheFactory, ISourceFileManager mSourceFileManager) {
        this.mCacheFactory = mCacheFactory;
        this.mSourceFileManager = mSourceFileManager;
    }

    @Override
    public boolean startup() {
        this.mResponseCache = this.mCacheFactory.getNamedCache(this.mResponseCacheName);
        if (this.mResponseCache == null) {
            throw new GeneralException("uncertain.cache.named_cache_not_found", new Object[]{this.mResponseCacheName}, this);
        }
        return true;
    }

    @Override
    public void shutdown() {
    }

    @Override
    public String getFullCacheKey(String key) {
        if (key == null) {
            return this.mResponseCacheKeyPrefix;
        }
        return String.valueOf(this.mResponseCacheKeyPrefix) + key;
    }

    @Override
    public String getFullCacheKey(File source_file, String key) {
        ISourceFile latest_file;
        StringBuffer full_key = new StringBuffer(source_file.getPath());
        if (this.mSourceFileManager != null && (latest_file = this.mSourceFileManager.getSourceFile(source_file)) != null) {
            long last_modified = latest_file.getLastModified();
            full_key.append(last_modified);
        }
        full_key.append(this.getFullCacheKey(key));
        return full_key.toString();
    }

    @Override
    public ICache getCacheForResponse() {
        return this.mResponseCache;
    }

    public String getResponseCacheKeyPrefix() {
        return this.mResponseCacheKeyPrefix;
    }

    public void setResponseCacheKeyPrefix(String screenCacheKeyPrefix) {
        this.mResponseCacheKeyPrefix = screenCacheKeyPrefix;
    }

    public String getResponseCacheName() {
        return this.mResponseCacheName;
    }

    public void setResponseCacheName(String screenCacheName) {
        this.mResponseCacheName = screenCacheName;
    }
}

