/*
 * Decompiled with CFR 0.152.
 */
package aurora.application.task;

import aurora.database.service.BusinessModelService;
import aurora.database.service.IDatabaseServiceFactory;
import aurora.database.service.SqlServiceContext;
import java.util.List;
import uncertain.composite.CompositeMap;
import uncertain.composite.DynamicObject;
import uncertain.composite.TextParser;
import uncertain.exception.BuiltinExceptionFactory;
import uncertain.ocm.IObjectRegistry;
import uncertain.proc.AbstractEntry;
import uncertain.proc.ProcedureConfigManager;
import uncertain.proc.ProcedureRunner;

public class AsyncTask
extends AbstractEntry {
    private IDatabaseServiceFactory mDatabaseServiceFactory;
    private String bm;
    private String taskName;
    private String taskDescription;
    private String executorInstance;
    private String procFilePath;
    private String procContent;
    private String context;
    private int priority;
    private String taskType;
    private String sql;
    private int retryTime;
    private int timeOut;
    private IObjectRegistry objectRegistry;

    public AsyncTask(IObjectRegistry objectRegistry, IDatabaseServiceFactory databaseServiceFactory) {
        this.objectRegistry = objectRegistry;
        this.mDatabaseServiceFactory = databaseServiceFactory;
    }

    @Override
    public void run(ProcedureRunner runner) throws Exception {
        this.execute(runner.getContext());
    }

    public void execute(CompositeMap context) throws Exception {
        CompositeMap parameters;
        SqlServiceContext sqlServiceContext = (SqlServiceContext)DynamicObject.cast(context, SqlServiceContext.class);
        sqlServiceContext.initConnection(this.objectRegistry, null);
        CompositeMap contextClone = (CompositeMap)context.clone();
        String strContext = contextClone.toXML();
        if (this.bm == null) {
            throw BuiltinExceptionFactory.createAttributeMissing(this, "bm");
        }
        this.bm = TextParser.parse(this.bm, contextClone);
        if (this.taskType == null) {
            throw BuiltinExceptionFactory.createAttributeMissing(this, "taskType");
        }
        this.taskType = TextParser.parse(this.taskType, contextClone);
        if ("JAVA".equals(this.taskType)) {
            if (this.procFilePath == null && this.procContent == null) {
                throw BuiltinExceptionFactory.createOneAttributeMissing(this, "procFilePath,procContent");
            }
            if (this.procFilePath != null && this.procContent != null) {
                throw BuiltinExceptionFactory.createConflictAttributesExcepiton(this, "procFilePath,procContent");
            }
            this.procFilePath = TextParser.parse(this.procFilePath, contextClone);
        }
        if ("PROCEDURE".equals(this.taskType) || "FUNCTION".equals(this.taskType)) {
            if (this.sql == null) {
                throw BuiltinExceptionFactory.createAttributeMissing(this, "taskType");
            }
            this.sql = TextParser.parse(this.sql, contextClone);
        }
        if ((parameters = contextClone.getChild("parameter")) == null) {
            parameters = new CompositeMap("parameter");
            contextClone.addChild(parameters);
        }
        parameters.put("task_name", this.taskName);
        parameters.put("task_description", this.taskDescription);
        parameters.put("executor_instance", this.executorInstance);
        parameters.put("proc_file_path", this.procFilePath);
        parameters.put("proc_content", this.procContent);
        parameters.put("context", strContext);
        parameters.put("priority", (Object)this.priority);
        parameters.put("task_type", this.taskType);
        parameters.put("retry_time", (Object)this.retryTime);
        parameters.put("time_out", (Object)this.timeOut);
        BusinessModelService businessModelService = this.mDatabaseServiceFactory.getModelService(this.bm, contextClone);
        businessModelService.execute(parameters);
    }

    public String getBm() {
        return this.bm;
    }

    public void setBm(String bm) {
        this.bm = bm;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public void setTaskName(String taskName) {
        this.taskName = taskName;
    }

    public String getTaskDescription() {
        return this.taskDescription;
    }

    public void setTaskDescription(String taskDescription) {
        this.taskDescription = taskDescription;
    }

    public String getExecutorInstance() {
        return this.executorInstance;
    }

    public void setExecutorInstance(String executorInstance) {
        this.executorInstance = executorInstance;
    }

    public String getProcFilePath() {
        return this.procFilePath;
    }

    public void setProcFilePath(String procFilePath) {
        this.procFilePath = procFilePath;
    }

    public String getProcContent() {
        return this.procContent;
    }

    public void setProcContent(String procContent) {
        this.procContent = procContent;
    }

    public String getContext() {
        return this.context;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public String getTaskType() {
        return this.taskType;
    }

    public void setTaskType(String taskType) {
        this.taskType = taskType;
    }

    public String getSql() {
        return this.sql;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public int getRetryTime() {
        return this.retryTime;
    }

    public void setRetryTime(int retryTime) {
        this.retryTime = retryTime;
    }

    public int getTimeOut() {
        return this.timeOut;
    }

    public void setTimeOut(int timeOut) {
        this.timeOut = timeOut;
    }

    @Override
    public void beginConfigure(CompositeMap config) {
        List childs = config.getChilds();
        if (childs == null || childs.isEmpty()) {
            return;
        }
        CompositeMap proc_config = ProcedureConfigManager.createConfigNode("procedure");
        proc_config.addChilds(config.getChilds());
        this.procContent = proc_config.toXML();
    }
}

