/*
 * Decompiled with CFR 0.152.
 */
package aurora.bm;

import aurora.application.IApplicationConfig;
import aurora.bm.BusinessModel;
import aurora.database.service.BusinessModelService;
import aurora.database.service.DatabaseServiceFactory;
import aurora.events.E_CheckBMAccess;
import aurora.service.ServiceInstance;
import java.io.IOException;
import uncertain.composite.CompositeMap;
import uncertain.core.ConfigurationError;

public class DBModelAccessChecker
implements E_CheckBMAccess {
    IApplicationConfig mAppConfig;
    DatabaseServiceFactory mDbSvcFactory;
    String mBMCheckService;

    public DBModelAccessChecker(IApplicationConfig appConfig, DatabaseServiceFactory dbSvcFactory) throws IOException {
        Object value;
        this.mAppConfig = appConfig;
        this.mDbSvcFactory = dbSvcFactory;
        if (this.mAppConfig != null && (value = this.mAppConfig.getApplicationConfig().getObject("/access-control-config/@bmcheckservice")) != null) {
            this.mBMCheckService = value.toString();
        }
        if (this.mBMCheckService == null) {
            throw new ConfigurationError("Must set 'BMCheckService' property in 'access-control-config' element in application config file");
        }
        BusinessModel bm_check = this.mDbSvcFactory.getModelFactory().getModelForRead(this.mBMCheckService);
        if (bm_check == null) {
            throw new ConfigurationError("Can't load BM check service " + this.mBMCheckService);
        }
    }

    public static String getModelNameForAccessCheck(BusinessModel model) {
        String bm_name = model.getName();
        String mode = model.getAccessControlMode();
        BusinessModel parent = model.getParent();
        if (parent == null) {
            return bm_name;
        }
        if ("separate".equalsIgnoreCase(mode)) {
            return bm_name;
        }
        return DBModelAccessChecker.getModelNameForAccessCheck(parent);
    }

    @Override
    public void onCheckBMAccess(BusinessModel model, String operation_name, ServiceInstance svc) throws Exception {
        String bm_name = model.getName();
        bm_name = DBModelAccessChecker.getModelNameForAccessCheck(model);
        CompositeMap context = svc.getContextMap();
        context.putObject("/request/@bm_name", (Object)bm_name, true);
        context.putObject("/request/@operation_name", (Object)operation_name, true);
        BusinessModelService bmsc = this.mDbSvcFactory.getModelService(this.mBMCheckService);
        bmsc.execute(svc.getServiceContext().getParameter());
    }
}

