/*
 * Decompiled with CFR 0.152.
 */
package aurora.database;

import aurora.database.FetchDescriptor;
import aurora.database.SQLExceptionDescriptor;
import aurora.database.service.BusinessModelService;
import aurora.database.service.DatabaseServiceFactory;
import aurora.service.ServiceContext;
import java.util.HashMap;
import uncertain.composite.CompositeMap;
import uncertain.core.UncertainEngine;

public class DataBaseExceptionDescriptor
extends SQLExceptionDescriptor {
    private static final String SERVICE_NAME = "sys.sys_error_message";
    private UncertainEngine engine;

    public DataBaseExceptionDescriptor(UncertainEngine engine) {
        this.engine = engine;
    }

    @Override
    public CompositeMap process(ServiceContext context, Throwable exception) {
        return this.parseErrorMessage(context, exception);
    }

    private CompositeMap parseErrorMessage(ServiceContext context, Throwable exception) {
        CompositeMap err = context.getObjectContext().getChild("error");
        if (err != null && err.size() == 0) {
            err = null;
        }
        if (err != null) {
            return null;
        }
        CompositeMap error = new CompositeMap("error-message");
        String message = null;
        String code = null;
        try {
            String errMsg = exception.getMessage();
            int endIndex = errMsg.indexOf("\n");
            int startIndex = errMsg.indexOf(": ") + 2;
            Integer errLineId = new Integer(-1);
            try {
                errLineId = Integer.valueOf(errMsg.substring(startIndex, endIndex));
            }
            catch (Exception exception2) {
                // empty catch block
            }
            if (errLineId != -1) {
                HashMap<String, Integer> map = new HashMap<String, Integer>();
                map.put("lineId", errLineId);
                DatabaseServiceFactory svcFactory = (DatabaseServiceFactory)this.engine.getObjectRegistry().getInstanceOfType(DatabaseServiceFactory.class);
                BusinessModelService sqlService = svcFactory.getModelService(SERVICE_NAME, context.getObjectContext());
                CompositeMap resultMap = sqlService.queryAsMap(map, FetchDescriptor.getDefaultInstance());
                CompositeMap msg = (CompositeMap)resultMap.getChilds().get(0);
                message = (String)msg.getObject("@MESSAGE");
                code = (String)msg.getObject("@MESSAGE_CODE");
                error.put("message", message);
                error.put("code", code);
            } else {
                error.put("message", errMsg);
            }
            return error;
        }
        catch (Exception e) {
            e.printStackTrace();
            return super.getParsedError(context, exception);
        }
    }
}

