/*
 * Decompiled with CFR 0.152.
 */
package aurora.datasource;

import aurora.datasource.DatabaseConnection;
import aurora.datasource.IDataSourceFactory;
import aurora.datasource.INamedDataSourceProvider;
import aurora.datasource.NamedDataSourceProvider;
import aurora.plugin.xapool.TransactionService;
import aurora.plugin.xapool.XADataSources;
import aurora.service.IServiceFactory;
import aurora.service.ServiceFactoryImpl;
import aurora.transaction.ITransactionService;
import java.sql.Connection;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import javax.transaction.TransactionManager;
import org.enhydra.jdbc.pool.StandardXAPoolDataSource;
import org.enhydra.jdbc.standard.StandardXADataSource;
import uncertain.core.IContainer;
import uncertain.core.ILifeCycle;
import uncertain.logging.ILogger;
import uncertain.logging.LoggingContext;
import uncertain.ocm.IObjectRegistry;
import uncertain.ocm.OCManager;
import uncertain.proc.IProcedureManager;

public class DataSourceConfig
implements ILifeCycle {
    DatabaseConnection[] mDatabaseConnections;
    INamedDataSourceProvider dsProvider = new NamedDataSourceProvider();
    boolean useTransactionManager = false;
    IObjectRegistry mObjectRegistry;
    String className;
    ILogger mLogger;
    OCManager mOCManager;
    boolean flag = false;

    public DataSourceConfig(IObjectRegistry reg, OCManager ocManager) {
        this.mLogger = LoggingContext.getLogger("aurora.datasource", reg);
        this.mObjectRegistry = reg;
        this.mOCManager = ocManager;
    }

    private ServiceFactoryImpl createServiceFactory(ITransactionService ts) {
        IProcedureManager pr = (IProcedureManager)this.mObjectRegistry.getInstanceOfType(IProcedureManager.class);
        IContainer container = (IContainer)this.mObjectRegistry.getInstanceOfType(IContainer.class);
        ServiceFactoryImpl sf = new ServiceFactoryImpl(container, ts, pr);
        return sf;
    }

    @Override
    public boolean startup() {
        if (this.flag) {
            return true;
        }
        this.flag = true;
        DataSource ds = null;
        TransactionService ts = null;
        DatabaseConnection dbConfig = null;
        try {
            int length = this.mDatabaseConnections.length;
            if (this.useTransactionManager) {
                TransactionManager tm = null;
                ts = new TransactionService(true);
                tm = ts.getTransactionManager();
                int i = 0;
                while (i < length) {
                    dbConfig = this.mDatabaseConnections[i];
                    ds = XADataSources.unpooledXADataSource(dbConfig.getUrl(), dbConfig.getUserName(), dbConfig.getPassword(), dbConfig.getDriverClass(), tm);
                    if (dbConfig.getPool()) {
                        ds = XADataSources.pooledXADataSource((XADataSource)((Object)ds));
                        if (dbConfig.getConfig() != null) {
                            this.mOCManager.populateObject(dbConfig.getConfig(), (StandardXAPoolDataSource)ds);
                        }
                    }
                    this.registryDataSource(ds, dbConfig, this.dsProvider);
                    ++i;
                }
            } else {
                if (this.className == null) {
                    this.className = "aurora.plugin.c3p0.DataSourceFactory";
                }
                IDataSourceFactory dbFactory = (IDataSourceFactory)Class.forName(this.className).newInstance();
                ts = new TransactionService(false);
                int i = 0;
                while (i < length) {
                    dbConfig = this.mDatabaseConnections[i];
                    ds = dbFactory.createDataSource(dbConfig);
                    this.registryDataSource(ds, dbConfig, this.dsProvider);
                    ++i;
                }
            }
            this.mObjectRegistry.registerInstance(INamedDataSourceProvider.class, this.dsProvider);
            this.mObjectRegistry.registerInstance(ITransactionService.class, ts);
            ServiceFactoryImpl sf = this.createServiceFactory(ts);
            this.mObjectRegistry.registerInstance(IServiceFactory.class, sf);
            this.mObjectRegistry.registerInstance(DataSourceConfig.class, this);
            return true;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private void registryDataSource(DataSource ds, DatabaseConnection dbConfig, INamedDataSourceProvider dsProvider) throws RuntimeException {
        String dataSourceName = dbConfig.getName();
        if (ds == null) {
            this.mLogger.log(Level.SEVERE, "dataSource not initialized");
            throw new RuntimeException(String.valueOf(dataSourceName) + " dataSource not initialized");
        }
        if (dataSourceName == null) {
            this.mLogger.log(Level.CONFIG, "Setting up dataSource url:{0},user:{1}", new Object[]{dbConfig.getUrl(), dbConfig.getUserName()});
            this.mObjectRegistry.registerInstance(DataSource.class, ds);
        } else {
            ((NamedDataSourceProvider)dsProvider).putDataSource(dbConfig.getName(), ds);
            this.mLogger.log(Level.CONFIG, "Setting up dataSource url:{0},user:{1},name:{2}", new Object[]{dbConfig.getUrl(), dbConfig.getUserName(), dbConfig.getName()});
        }
    }

    public boolean getUseTransactionManager() {
        return this.useTransactionManager;
    }

    public void setUseTransactionManager(boolean useTransactionManager) {
        this.useTransactionManager = useTransactionManager;
    }

    public DatabaseConnection[] getDatabaseConnections() {
        return this.mDatabaseConnections;
    }

    public void setDatabaseConnections(DatabaseConnection[] DataBases) {
        this.mDatabaseConnections = DataBases;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    @Override
    public void shutdown() {
        DataSource ds = (DataSource)this.mObjectRegistry.getInstanceOfType(DataSource.class);
        INamedDataSourceProvider dsProvider = (INamedDataSourceProvider)this.mObjectRegistry.getInstanceOfType(INamedDataSourceProvider.class);
        this.cleanDataSource(ds);
        if (dsProvider != null) {
            Map dsMap = dsProvider.getAllDataSources();
            Iterator iterator = dsMap.keySet().iterator();
            while (iterator.hasNext()) {
                ds = (DataSource)dsMap.get(iterator.next());
                this.cleanDataSource(ds);
            }
        }
    }

    void cleanDataSource(DataSource ds) {
        if (ds != null) {
            try {
                IDataSourceFactory dbFactory = (IDataSourceFactory)Class.forName(this.className).newInstance();
                dbFactory.cleanDataSource(ds);
            }
            catch (Exception e) {
                this.mLogger.log(Level.SEVERE, e.getMessage(), e.getCause());
            }
            if (ds instanceof StandardXADataSource) {
                ((StandardXADataSource)ds).shutdown(true);
            }
            if (ds instanceof StandardXAPoolDataSource) {
                ((StandardXAPoolDataSource)ds).stopPool();
            }
        }
    }

    public Connection getNativeJdbcExtractor(Connection conn) throws Exception {
        Connection nativeConn = null;
        IDataSourceFactory dbFactory = (IDataSourceFactory)Class.forName(this.className).newInstance();
        nativeConn = dbFactory.getNativeJdbcExtractor(conn);
        return nativeConn;
    }
}

