/*
 * Decompiled with CFR 0.152.
 */
package aurora.presentation.component.std;

import aurora.database.service.BusinessModelService;
import aurora.database.service.IDatabaseServiceFactory;
import aurora.presentation.BuildSession;
import aurora.presentation.ViewContext;
import aurora.presentation.component.std.Component;
import aurora.presentation.component.std.JSONFunction;
import aurora.service.ServiceThreadLocal;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;
import uncertain.composite.CompositeMap;
import uncertain.composite.TextParser;

public class Comment
extends Component {
    public static final String VERSION = "$Revision: 7033 $";
    private static final String DEFAULT_CLASS = "comments";
    private IDatabaseServiceFactory factory;
    private String model = "doc.doc_comment";
    private static final String PROPERTITY_TABLE_NAME = "tablename";
    private static final String PROPERTITY_BIND_ID = "bindid";
    private static final String PROPERTITY_REGISTER_HANDLER = "registerhandler";
    private static final String PROPERTITY_LOGIN_HANDLER = "loginhandler";
    private SimpleDateFormat parseDate;
    private SimpleDateFormat formatDate;
    private Object userId;

    @Override
    public void onPreparePageContent(BuildSession session, ViewContext context) throws IOException {
        super.onPreparePageContent(session, context);
        this.addStyleSheet(session, context, "comment/comment.css");
        this.addJavaScript(session, context, "comment/comment.js");
    }

    @Override
    protected String getDefaultClass(BuildSession session, ViewContext context) {
        return DEFAULT_CLASS;
    }

    public Comment(IDatabaseServiceFactory factory) {
        this.factory = factory;
        this.parseDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        this.formatDate = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5 HH:mm");
    }

    @Override
    public void onCreateViewContent(BuildSession session, ViewContext context) throws IOException {
        super.onCreateViewContent(session, context);
        Map map = context.getMap();
        try {
            StringBuffer content;
            CompositeMap sessionmap = (CompositeMap)context.getModel().getObject("/session");
            if (sessionmap != null) {
                this.userId = sessionmap.get("user_id");
                this.addConfig("username", this.findUserName(this.userId));
            }
            CompositeMap comments = this.init(session, context);
            int length = 0;
            if (comments.getChilds() != null) {
                content = new StringBuffer("<ol class='comment-list'>");
                length = comments.getChilds().size();
                Iterator it = comments.getChildIterator();
                while (it.hasNext()) {
                    content.append(this.createComment((CompositeMap)it.next()));
                }
                content.append("</ol>");
            } else {
                content = new StringBuffer("<p class='comment-li'>\u6682\u65f6\u6ca1\u6709\u8bc4\u8bba\u3002</p>");
            }
            map.put("length", new Integer(length));
            map.put("list", content.toString());
            map.put("txt", this.createTextArea(session, context));
            map.put("btn", this.createButton(session, context));
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
        this.addConfig("submiturl", String.valueOf(session.getContextPath()) + "/autocrud/" + this.model);
        map.put("config", this.getConfigString());
    }

    private String createComment(CompositeMap comment) throws ParseException {
        String content = comment.getString("content");
        if (content == null) {
            content = "";
        }
        content = this.replaceAll(">", this.replaceAll("<", this.replaceAll("&", content, "&amp;"), "&lt;"), "&gt;");
        String author = comment.getString("user_name");
        Long author_id = comment.getLong("created_by");
        String date = comment.getString("creation_date");
        String commentId = comment.getString("comment_id");
        date = this.formatDate.format(this.parseDate.parse(date));
        StringBuffer buffer = new StringBuffer("<li id='" + this.id + "_" + commentId + "' class='comment-li'>");
        buffer.append("<div>");
        buffer.append("<div class='comment-nick'><cite>" + author + "</cite> <span>\u7559\u8a00\u4e8e\uff1a" + date + "</span></div>");
        buffer.append("<div class='comment-txt'>" + content + "</div>");
        buffer.append("</div>");
        if (author_id != null && author_id.toString().equals(this.userId)) {
            buffer.append("<div class='comment-bar'><a href='javascript:$(\"" + this.id + "\").remove(\"" + commentId + "\")'>\u5220\u9664</a></div>");
        }
        buffer.append("</li>");
        return buffer.toString();
    }

    private String createTextArea(BuildSession session, ViewContext context) throws Exception {
        CompositeMap model = context.getModel();
        CompositeMap textArea = new CompositeMap("textArea");
        textArea.setNameSpaceURI("http://www.aurora-framework.org/application");
        textArea.put("id", String.valueOf(this.id) + "_txt");
        textArea.put("style", "width:99%;height:150px");
        if (this.userId == null) {
            textArea.put("readonly", new Boolean(true));
        }
        return session.buildViewAsString(model, textArea);
    }

    private String createButton(BuildSession session, ViewContext context) throws Exception {
        CompositeMap model = context.getModel();
        CompositeMap button = new CompositeMap("button");
        button.setNameSpaceURI("http://www.aurora-framework.org/application");
        button.put("id", String.valueOf(this.id) + "_btn");
        button.put("icon", (Object)null);
        button.put("text", "\u53d1 \u8868 \u8bc4 \u8bba");
        button.put("width", (Object)100);
        button.put("click", "function(){$('" + this.id + "').post()}");
        if (this.userId == null) {
            button.put("disabled", new Boolean(true));
        }
        return session.buildViewAsString(model, button);
    }

    private CompositeMap init(BuildSession session, ViewContext view_context) throws Exception {
        String loginHandler;
        CompositeMap view = view_context.getView();
        String tableName = view.getString(PROPERTITY_TABLE_NAME);
        String bindId = view.getString(PROPERTITY_BIND_ID);
        if (bindId == null) {
            throw new IllegalStateException("The property 'bindId' of The comment component is required.");
        }
        String registerHandler = view.getString(PROPERTITY_REGISTER_HANDLER);
        if (registerHandler != null) {
            this.addConfig(PROPERTITY_REGISTER_HANDLER, new JSONFunction(registerHandler));
        }
        if ((loginHandler = view.getString(PROPERTITY_LOGIN_HANDLER)) != null) {
            this.addConfig(PROPERTITY_LOGIN_HANDLER, new JSONFunction(loginHandler));
        }
        bindId = TextParser.parse(bindId, view_context.getModel());
        CompositeMap context = ServiceThreadLocal.getCurrentThreadContext();
        if (context == null) {
            throw new IllegalStateException("No service context set in ThreadLocal yet");
        }
        BusinessModelService service = this.factory.getModelService(this.model, context);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("table_id", bindId);
        map.put("table_name", tableName);
        this.addConfig("tableid", bindId);
        this.addConfig(PROPERTITY_TABLE_NAME, tableName);
        return service.queryAsMap(map);
    }

    private String findUserName(Object userId) throws Exception {
        CompositeMap context = ServiceThreadLocal.getCurrentThreadContext();
        if (context == null) {
            throw new IllegalStateException("No service context set in ThreadLocal yet");
        }
        BusinessModelService service = this.factory.getModelService("sys.sys_user", context);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("user_id", userId);
        CompositeMap cm = service.queryAsMap(map);
        if (cm == null) {
            return null;
        }
        Iterator childs = cm.getChildIterator();
        if (childs.hasNext()) {
            return (String)((CompositeMap)childs.next()).get("user_name");
        }
        return null;
    }

    private String replaceAll(String regex, CharSequence input, String replacement) {
        return Pattern.compile(regex, 32).matcher(input).replaceAll(replacement);
    }
}

