/*
 * Decompiled with CFR 0.152.
 */
package aurora.presentation.component.std;

import aurora.application.ApplicationConfig;
import aurora.application.ApplicationViewConfig;
import aurora.application.IApplicationConfig;
import aurora.application.features.ILookupCodeProvider;
import aurora.bm.BusinessModel;
import aurora.bm.Field;
import aurora.bm.IModelFactory;
import aurora.presentation.BuildSession;
import aurora.presentation.ViewContext;
import aurora.presentation.component.std.Component;
import aurora.presentation.component.std.config.DataSetConfig;
import aurora.presentation.component.std.config.DataSetFieldConfig;
import aurora.presentation.component.std.config.LovConfig;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import uncertain.composite.CompositeMap;
import uncertain.composite.TextParser;
import uncertain.ocm.IObjectRegistry;

public class DataSet
extends Component {
    public static final String VERSION = "$Revision: 7114 $";
    private static final String VALID_SCRIPT = "validscript";
    private IModelFactory mFactory;
    private ILookupCodeProvider lookupProvider;
    private IObjectRegistry mRegistry;
    private ApplicationConfig mApplicationConfig;

    public DataSet(IObjectRegistry registry, IModelFactory factory, ILookupCodeProvider lookupProvider) {
        this.mRegistry = registry;
        this.mFactory = factory;
        this.lookupProvider = lookupProvider;
        this.mApplicationConfig = (ApplicationConfig)this.mRegistry.getInstanceOfType(IApplicationConfig.class);
    }

    public DataSet(IObjectRegistry registry, IModelFactory factory) {
        this.mRegistry = registry;
        this.mFactory = factory;
        this.mApplicationConfig = (ApplicationConfig)this.mRegistry.getInstanceOfType(IApplicationConfig.class);
    }

    private void initLovService(String baseModel, BuildSession session, CompositeMap field) throws IOException {
        BusinessModel bm = null;
        bm = this.mFactory.getModelForRead(baseModel.split("\\?")[0]);
        Field[] bmfields = bm.getFields();
        JSONArray lovDisplayFields = new JSONArray();
        if (bmfields != null) {
            int i = 0;
            int l = bmfields.length;
            while (i < l) {
                Field f = bmfields[i];
                if (f.isForDisplay()) {
                    DataSetFieldConfig dfc = DataSetFieldConfig.getInstance(f.getObjectContext());
                    dfc.setPrompt(session.getLocalizedPrompt(dfc.getPrompt()));
                    lovDisplayFields.put(new JSONObject(dfc.getObjectContext()));
                }
                ++i;
            }
        }
        field.put("displayFields", lovDisplayFields);
    }

    @Override
    public void onCreateViewContent(BuildSession session, ViewContext context) throws IOException {
        ILookupCodeProvider provider;
        String lcode;
        Iterator it;
        DataSetConfig dsc;
        CompositeMap fields;
        ApplicationViewConfig view_config;
        super.onCreateViewContent(session, context);
        CompositeMap view = context.getView();
        CompositeMap model = context.getModel();
        Map map = context.getMap();
        JSONArray fieldList = new JSONArray();
        int mDefaultPageSize = -1;
        boolean mDefaultModifiedCheck = true;
        boolean autoCount = true;
        if (this.mApplicationConfig != null && (view_config = this.mApplicationConfig.getApplicationViewConfig()) != null) {
            mDefaultPageSize = view_config.getDefaultPageSize();
            mDefaultModifiedCheck = view_config.getDefaultModifiedCheck();
            autoCount = view_config.getDefaultAutoCount();
        }
        if ((fields = (dsc = DataSetConfig.getInstance(view)).getFields()) != null && (it = fields.getChildIterator()) != null) {
            while (it.hasNext()) {
                String returnField;
                String lovTitle;
                String lovUrl;
                String lovModel;
                String lovService;
                String options;
                CompositeMap field = (CompositeMap)it.next();
                DataSetFieldConfig sdfc = DataSetFieldConfig.getInstance(field);
                if (field.getString("required") != null) {
                    field.putBoolean("required", sdfc.getRequired());
                }
                if (field.getString("readonly") != null) {
                    field.putBoolean("readonly", sdfc.getReadOnly());
                }
                if (field.getString("editable") != null) {
                    field.putBoolean("editable", sdfc.getEditable());
                }
                if (field.getString("autocomplete") != null) {
                    field.putBoolean("autocomplete", sdfc.getAutoComplete());
                }
                if (sdfc.getDefaultValue() != null) {
                    field.putString("defaultvalue", session.parseString(sdfc.getDefaultValue(), model));
                }
                if ((options = field.getString("options")) != null) {
                    field.putString("options", TextParser.parse(options, model));
                }
                LovConfig lc = LovConfig.getInstance(field);
                if (field.getString("fetchremote") != null) {
                    field.putBoolean("fetchremote", lc.getFetchRemote());
                }
                if (field.getString("fetchsingle") != null) {
                    field.putBoolean("fetchsingle", lc.getFetchSingle());
                }
                if ((lovService = field.getString("lovservice")) != null && lovService.length() > 0) {
                    String baseModel = TextParser.parse(lovService, model);
                    field.putString("lovservice", baseModel);
                    this.initLovService(baseModel, session, field);
                }
                if ((lovModel = field.getString("lovmodel")) != null) {
                    String baseModel = TextParser.parse(lovModel, model);
                    field.putString("lovmodel", baseModel);
                    this.initLovService(baseModel, session, field);
                }
                if ((lovUrl = field.getString("lovurl")) != null) {
                    field.putString("lovurl", TextParser.parse(lovUrl, model));
                }
                if ((lovTitle = field.getString("title")) != null) {
                    field.putString("title", session.getLocalizedPrompt(lovTitle));
                }
                boolean addReturn = (returnField = sdfc.getReturnField()) != null;
                field.remove("databasetype");
                String datatype = field.getString("datatype");
                if ("java.lang.String".equals(datatype)) {
                    field.remove("datatype");
                }
                JSONObject json = new JSONObject(field);
                CompositeMap mapping = sdfc.getMapping();
                ArrayList<JSONObject> maplist = new ArrayList<JSONObject>();
                if (mapping != null) {
                    Iterator mit = mapping.getChildIterator();
                    while (mit.hasNext()) {
                        CompositeMap mapfield = (CompositeMap)mit.next();
                        if (returnField != null && returnField.equals(mapfield.getString("to"))) {
                            addReturn = false;
                        }
                        JSONObject mj = new JSONObject(mapfield);
                        maplist.add(mj);
                    }
                }
                if (addReturn) {
                    CompositeMap returnmap = new CompositeMap("map");
                    returnmap.putString("from", sdfc.getValueField());
                    returnmap.putString("to", returnField);
                    JSONObject jo = new JSONObject(returnmap);
                    maplist.add(jo);
                }
                if (maplist.size() > 0) {
                    try {
                        json.put("mapping", maplist);
                    }
                    catch (JSONException e) {
                        throw new IOException(e.getMessage());
                    }
                }
                fieldList.put(json);
            }
        }
        StringBuffer sb = new StringBuffer();
        String attachTab = dsc.getValidListener();
        if (attachTab != null) {
            String[] ts = attachTab.split(",");
            int i = 0;
            while (i < ts.length) {
                String tid = ts[i];
                sb.append("$('" + map.get("id") + "').on('valid',function(ds, record, name, valid){if(!valid && !Ext.get('" + tid + "').hasActiveFx()) Ext.get('" + tid + "').frame('ff0000', 3, { duration: 1 })});\n");
                ++i;
            }
        }
        map.put(VALID_SCRIPT, sb.toString());
        CompositeMap datas = dsc.getDatas();
        JSONArray dataList = new JSONArray();
        List list = null;
        HashSet dataHead = new HashSet();
        if (datas != null) {
            String ds = datas.getString("datasource", "");
            if (ds.equals("")) {
                list = datas.getChilds();
                for (CompositeMap item : list) {
                    Iterator it2 = item.keySet().iterator();
                    dataHead.addAll(item.keySet());
                    while (it2.hasNext()) {
                        String key = (String)it2.next();
                        Object valueKey = item.get(key);
                        if (valueKey == null) continue;
                        String value = TextParser.parse(valueKey.toString(), model);
                        if (value.equals(valueKey.toString())) {
                            item.put(key, valueKey);
                            continue;
                        }
                        item.put(key, value);
                    }
                }
            } else {
                CompositeMap data = (CompositeMap)model.getObject(ds);
                if (data != null) {
                    list = data.getChilds();
                }
            }
        }
        if ((lcode = dsc.getLookupCode()) != null && (provider = this.lookupProvider) != null) {
            list = new ArrayList();
            try {
                list = provider.getLookupList(session.getLanguage(), lcode);
            }
            catch (Exception e) {
                throw new IOException(e.getMessage());
            }
        }
        if (list != null && !list.isEmpty()) {
            Iterator lit = list.iterator();
            while (lit.hasNext()) {
                dataHead.addAll(((CompositeMap)lit.next()).keySet());
            }
            this.addConfig("datahead", new JSONArray(dataHead));
            for (CompositeMap item : list) {
                JSONArray json = new JSONArray();
                Iterator it3 = dataHead.iterator();
                while (it3.hasNext()) {
                    json.put(item.get(it3.next()));
                }
                dataList.put(json);
            }
        }
        if (fieldList.length() != 0) {
            this.addConfig("fields", fieldList);
        }
        if (dataList.length() != 0) {
            this.addConfig("datas", dataList);
        }
        if (!"".equals(dsc.getQueryDataSet())) {
            this.addConfig("querydataset", dsc.getQueryDataSet());
        }
        if (!"".equals(dsc.getQueryUrl())) {
            String queryUrl = TextParser.parse(dsc.getQueryUrl(), model);
            this.addConfig("queryurl", queryUrl);
        }
        if (!"".equals(dsc.getSubmitUrl())) {
            String submitUrl = TextParser.parse(dsc.getSubmitUrl(), model);
            this.addConfig("submiturl", submitUrl);
        }
        if (!"".equals(dsc.getBindTarget())) {
            this.addConfig("bindtarget", TextParser.parse(dsc.getBindTarget(), model));
        }
        if (!"".equals(dsc.getBindName())) {
            this.addConfig("bindname", TextParser.parse(dsc.getBindName(), model));
        }
        if (dsc.isFetchAll()) {
            this.addConfig("fetchall", new Boolean(dsc.isFetchAll()));
        }
        String autoQuery = dsc.getString("autoquery", "false");
        Boolean isAutoQuery = Boolean.FALSE;
        if (!"false".equals(autoQuery) && "true".equalsIgnoreCase(autoQuery = TextParser.parse(autoQuery, model))) {
            isAutoQuery = Boolean.TRUE;
        }
        if (isAutoQuery.booleanValue()) {
            this.addConfig("autoquery", isAutoQuery);
        }
        if (dsc.isAutoPageSize()) {
            this.addConfig("autopagesize", new Boolean(dsc.isAutoPageSize()));
        }
        this.addConfig("pageid", session.getSessionContext().getString("pageid", ""));
        this.addConfig("totalcountfield", dsc.getTotalCountField());
        this.addConfig("modifiedcheck", dsc.isModifiedCheck(mDefaultModifiedCheck));
        BusinessModel bm = null;
        Integer mps = null;
        String md = dsc.getModel();
        if (md != null) {
            bm = this.mFactory.getModelForRead(TextParser.parse(md, model));
        }
        if (bm != null) {
            mps = bm.getMaxPageSize();
        }
        if (mps != null) {
            this.addConfig("maxpagesize", new Integer(mps));
        } else {
            this.addConfig("maxpagesize", new Integer(dsc.getMaxPageSize()));
        }
        int page_size = mDefaultPageSize < 0 ? dsc.getPageSize() : mDefaultPageSize;
        this.addConfig("pagesize", new Integer(page_size));
        Boolean isAutoCount = dsc.isAutoCount() != null ? dsc.isAutoCount() : autoCount;
        this.addConfig("autocount", isAutoCount);
        if (dsc.getSortType() != null) {
            this.addConfig("sorttype", dsc.getSortType());
        }
        if (dsc.getNotification() != null) {
            this.addConfig("notification", dsc.getNotification());
        }
        if (dsc.isAutoCreate()) {
            this.addConfig("autocreate", new Boolean(dsc.isAutoCreate()));
        }
        if (dsc.isSelectable()) {
            this.addConfig("selectable", new Boolean(dsc.isSelectable()));
        }
        if (dsc.getSelectFunction() != null) {
            this.addConfig("selectfunction", dsc.getSelectFunction());
        }
        if (!"multiple".equals(dsc.getSelectionModel())) {
            this.addConfig("selectionmodel", dsc.getSelectionModel());
        }
        if (!"".equals(dsc.getProcessFunction())) {
            this.addConfig("processfunction", dsc.getProcessFunction());
        }
        map.put("config", this.getConfigString());
    }
}

