/*
 * Decompiled with CFR 0.152.
 */
package aurora.presentation.component.touch;

import aurora.presentation.BuildSession;
import aurora.presentation.ViewComponentPackage;
import aurora.presentation.ViewContext;
import aurora.presentation.component.std.IDGenerator;
import aurora.presentation.component.std.config.EventConfig;
import aurora.presentation.markup.HtmlPageContext;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONString;
import uncertain.composite.CompositeMap;
import uncertain.composite.TextParser;
import uncertain.event.Configuration;
import uncertain.proc.IFeature;

public class Component
implements IFeature {
    CompositeMap view_config;
    protected static final String CLASS = "cls";
    protected static final String CONFIG = "config";
    protected static final String LISTENERS = "listeners";
    protected String id;
    private JSONObject config = new JSONObject();

    public void onPreparePageContent(BuildSession session, ViewContext context) throws IOException {
        this.addJavaScript(session, context, "base/zepto.min.js");
        this.addJavaScript(session, context, "base/touch-min.js");
        this.addStyleSheet(session, context, "base/touch-all-min.css");
    }

    protected String getDefaultClass(BuildSession session, ViewContext context) {
        return "";
    }

    public void onCreateViewContent(BuildSession session, ViewContext context) throws IOException {
        List list;
        CompositeMap view = context.getView();
        Map map = context.getMap();
        CompositeMap model = context.getModel();
        String id = view.getString("id", "");
        if ("".equals(id)) {
            id = IDGenerator.getInstance().generate();
        }
        String ids = "id=\"" + id + "\"";
        map.put("id", ids);
        this.addConfig("id", id);
        String clazz = this.getDefaultClass(session, context);
        String className = view.getString("classname", "");
        if (!"".equals(className)) {
            clazz = String.valueOf(clazz) + " " + className;
        }
        map.put(CLASS, clazz);
        String style = view.getString("style", "");
        if (!"".equals(style)) {
            style = "style=\"" + style + "\"";
        }
        map.put("style", style);
        CompositeMap events = view.getChild("events");
        if (events != null && (list = events.getChilds()) != null) {
            StringBuffer sb = new StringBuffer("<script>");
            for (CompositeMap event : list) {
                EventConfig eventConfig = EventConfig.getInstance(event);
                String eventName = eventConfig.getEventName();
                String handler = eventConfig.getHandler();
                if (!"".equals(eventName) && !"".equals(handler)) {
                    handler = TextParser.parse(handler, model);
                }
                sb.append("$('#").append(id).append("')").append(".on('").append(eventName).append("',").append(handler).append(");");
            }
            sb.append("</script>");
            map.put("events", sb.toString());
        }
    }

    protected void addJavaScript(BuildSession session, ViewContext context, String javascript) {
        if (!session.includeResource(javascript)) {
            HtmlPageContext page = HtmlPageContext.getInstance(context);
            ViewComponentPackage pkg = session.getPresentationManager().getPackage(this.view_config);
            String js = session.getResourceUrl(pkg, javascript);
            page.addScript(js);
        }
    }

    protected void addStyleSheet(BuildSession session, ViewContext context, String style) {
        if (!session.includeResource(style)) {
            HtmlPageContext page = HtmlPageContext.getInstance(context);
            ViewComponentPackage pkg = session.getPresentationManager().getPackage(this.view_config);
            String styleSheet = session.getResourceUrl(pkg, style);
            page.addStyleSheet(styleSheet);
        }
    }

    protected void addEvents(CompositeMap view, CompositeMap model) {
        List list;
        CompositeMap events = view.getChild("events");
        HashMap<String, JSONFunction> listeners = new HashMap<String, JSONFunction>();
        if (events != null && (list = events.getChilds()) != null) {
            for (CompositeMap event : list) {
                EventConfig eventConfig = EventConfig.getInstance(event);
                String eventName = eventConfig.getEventName();
                String handler = eventConfig.getHandler();
                if (!"".equals(eventName) && !"".equals(handler)) {
                    handler = TextParser.parse(handler, model);
                }
                listeners.put(eventName, new JSONFunction(handler));
            }
        }
        if (!listeners.isEmpty()) {
            this.addConfig(LISTENERS, new JSONObject(listeners));
        }
    }

    @Override
    public int attachTo(CompositeMap config_data, Configuration config) {
        this.view_config = config_data;
        return 0;
    }

    protected String getConfigString() {
        return this.config.toString();
    }

    protected JSONObject getConfig() {
        return this.config;
    }

    protected void addConfig(String key, Object value) {
        try {
            this.config.put(key, value);
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    class JSONFunction
    implements JSONString {
        private String funciton;

        public JSONFunction(String func) {
            this.funciton = func;
        }

        @Override
        public String toJSONString() {
            return this.funciton;
        }
    }
}

