/*
 * Decompiled with CFR 0.152.
 */
package aurora.security;

import aurora.application.ISessionInfoProvider;
import aurora.database.FetchDescriptor;
import aurora.database.service.BusinessModelService;
import aurora.database.service.DatabaseServiceFactory;
import aurora.database.service.IDatabaseServiceFactory;
import aurora.database.service.SqlServiceContext;
import aurora.security.IResourceAccessChecker;
import uncertain.composite.CompositeMap;
import uncertain.composite.TextParser;
import uncertain.core.IGlobalInstance;
import uncertain.exception.BuiltinExceptionFactory;
import uncertain.ocm.AbstractLocatableObject;
import uncertain.ocm.IObjectRegistry;

public class DefaultResourceAccessChecker
extends AbstractLocatableObject
implements IResourceAccessChecker,
IGlobalInstance {
    IObjectRegistry mRegistry;
    ISessionInfoProvider mSessionInfoProvider;
    IDatabaseServiceFactory mServiceFactory;
    String resourceBM;
    String accessBM;
    String accessKeyPrefix;
    String loginFlag;
    String accessCheckFlag;

    public DefaultResourceAccessChecker(IObjectRegistry mRegistry) {
        this.mRegistry = mRegistry;
    }

    public void onInitialize() {
        this.mServiceFactory = (DatabaseServiceFactory)this.mRegistry.getInstanceOfType(IDatabaseServiceFactory.class);
        if (this.mServiceFactory == null) {
            throw BuiltinExceptionFactory.createInstanceNotFoundException(this, IDatabaseServiceFactory.class, this.getClass().getName());
        }
        this.mSessionInfoProvider = (ISessionInfoProvider)this.mRegistry.getInstanceOfType(ISessionInfoProvider.class);
        if (this.mSessionInfoProvider == null) {
            throw BuiltinExceptionFactory.createInstanceNotFoundException(this, ISessionInfoProvider.class, this.getClass().getName());
        }
        if (this.accessBM == null) {
            throw BuiltinExceptionFactory.createAttributeMissing(this, "accessBM");
        }
        if (this.resourceBM == null) {
            throw BuiltinExceptionFactory.createAttributeMissing(this, "resourceBM");
        }
    }

    @Override
    public String checkAccess(String resource, CompositeMap session_context) {
        CompositeMap records;
        block12: {
            session_context.put("service_name", resource);
            try {
                records = this.queryBM(this.resourceBM, session_context);
                if (records != null && records.getChilds() != null) break block12;
                return "unregistered";
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        CompositeMap resource_map = (CompositeMap)records.getChilds().get(0);
        if (resource_map == null) {
            return "unregistered";
        }
        Boolean need_login = resource_map.getBoolean(this.loginFlag);
        if (need_login == null) {
            throw new RuntimeException(String.valueOf(this.loginFlag) + " not defined in " + resource_map.toXML());
        }
        Boolean need_access_check = resource_map.getBoolean(this.accessCheckFlag);
        if (need_access_check == null) {
            throw new RuntimeException(String.valueOf(this.accessCheckFlag) + " not defined in " + resource_map.toXML());
        }
        boolean is_logged_in = this.mSessionInfoProvider.isLoggedin(session_context);
        if (!is_logged_in && need_login.booleanValue()) {
            return "login_required";
        }
        if (need_access_check.booleanValue()) {
            CompositeMap records2;
            String key;
            block13: {
                key = this.accessKeyPrefix == null ? resource : String.valueOf(TextParser.parse(this.accessKeyPrefix, session_context)) + resource;
                try {
                    records2 = this.queryBM(this.accessBM, session_context);
                    if (records2 != null && records2.getChilds() != null) break block13;
                    return "unauthorized";
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            CompositeMap access_map = (CompositeMap)records2.getChilds().get(0);
            if (access_map == null || !key.equals(access_map.get("role_service"))) {
                return "unauthorized";
            }
        }
        return "success";
    }

    public String getResourceBM() {
        return this.resourceBM;
    }

    public void setResourceBM(String resourceBM) {
        this.resourceBM = resourceBM;
    }

    public String getAccessBM() {
        return this.accessBM;
    }

    public void setAccessBM(String accessBM) {
        this.accessBM = accessBM;
    }

    public String getAccessKeyPrefix() {
        return this.accessKeyPrefix;
    }

    public void setAccessKeyPrefix(String accessKeyPrefix) {
        this.accessKeyPrefix = accessKeyPrefix;
    }

    public String getLoginFlag() {
        return this.loginFlag;
    }

    public void setLoginFlag(String loginFlag) {
        this.loginFlag = loginFlag;
    }

    public String getAccessCheckFlag() {
        return this.accessCheckFlag;
    }

    public void setAccessCheckFlag(String accessCheckFlag) {
        this.accessCheckFlag = accessCheckFlag;
    }

    private CompositeMap queryBM(String bm, CompositeMap session_context) throws Exception {
        SqlServiceContext context = this.mServiceFactory.createContextWithConnection();
        try {
            CompositeMap resultMap;
            BusinessModelService service = this.mServiceFactory.getModelService(bm, context.getObjectContext());
            CompositeMap compositeMap = resultMap = service.queryAsMap(session_context, FetchDescriptor.fetchAll());
            return compositeMap;
        }
        finally {
            if (context != null) {
                context.freeConnection();
            }
        }
    }
}

